/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.helper;

import evilcraft.core.helper.MinecraftHelpers;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryHelpers {
    public static void clearInventory(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            inventory.func_70299_a(i, null);
        }
    }

    public static void tryReAddToStack(EntityPlayer player, ItemStack originalStack, ItemStack newStackPart) {
        if (!player.field_71075_bZ.field_75098_d) {
            if (--originalStack.func_77946_l().field_77994_a == 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newStackPart);
            } else {
                --originalStack.field_77994_a;
                if (newStackPart != null && !player.field_71071_by.func_70441_a(newStackPart)) {
                    player.func_71019_a(newStackPart, false);
                }
            }
        }
    }

    public static void validateNBTStorage(IInventory inventory, ItemStack itemStack, String tagName) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        if (!tag.func_74764_b(tagName)) {
            tag.func_74782_a(tagName, (NBTBase)new NBTTagList());
        }
        InventoryHelpers.readFromNBT(inventory, tag, tagName);
    }

    public static void readFromNBT(IInventory inventory, NBTTagCompound data, String tagName) {
        int j;
        NBTTagList nbttaglist = data.func_150295_c(tagName, MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
        for (j = 0; j < inventory.func_70302_i_(); ++j) {
            inventory.func_70299_a(j, null);
        }
        for (j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound slot = nbttaglist.func_150305_b(j);
            int index = slot.func_74764_b("index") ? slot.func_74762_e("index") : (int)slot.func_74771_c("Slot");
            if (index < 0 || index >= inventory.func_70302_i_()) continue;
            inventory.func_70299_a(index, ItemStack.func_77949_a((NBTTagCompound)slot));
        }
    }

    public static void writeToNBT(IInventory inventory, NBTTagCompound data, String tagName) {
        NBTTagList slots = new NBTTagList();
        for (int index = 0; index < inventory.func_70302_i_(); index = (int)((byte)(index + 1))) {
            ItemStack itemStack = inventory.func_70301_a(index);
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            NBTTagCompound slot = new NBTTagCompound();
            slot.func_74768_a("index", index);
            slots.func_74742_a((NBTBase)slot);
            itemStack.func_77955_b(slot);
        }
        data.func_74782_a(tagName, (NBTBase)slots);
    }

    public static ItemStack getItemFromIndex(EntityPlayer player, int itemIndex) {
        return player.field_71071_by.field_70462_a[itemIndex];
    }

    public static boolean addToSlot(IInventory inventory, int slot, ItemStack itemStack) {
        ItemStack produceStack = inventory.func_70301_a(slot);
        if (produceStack == null) {
            inventory.func_70299_a(slot, itemStack);
            return true;
        }
        if (produceStack.func_77973_b() == itemStack.func_77973_b() && produceStack.func_77976_d() >= produceStack.field_77994_a + itemStack.field_77994_a) {
            produceStack.field_77994_a += itemStack.field_77994_a;
            return true;
        }
        return false;
    }
}

