/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.helper;

import cpw.mods.fml.common.network.NetworkRegistry;
import evilcraft.api.ILocation;
import evilcraft.core.algorithm.Location;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LocationHelpers {
    private static final Random random = new Random();

    public static NetworkRegistry.TargetPoint createTargetPointFromEntityPosition(Entity entity, int range) {
        return new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (double)range);
    }

    public static NetworkRegistry.TargetPoint createTargetPointFromLocation(World world, ILocation location, int range) {
        int[] c = LocationHelpers.validateLocation(location);
        return new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)c[0], (double)c[1], (double)c[2], (double)range);
    }

    public static double getDistance(ILocation first, ILocation second) {
        int[] c2;
        int[] c1 = first.getCoordinates();
        if (c1.length != (c2 = second.getCoordinates()).length) {
            throw new LocationException("The locations {" + first + ", " + second + "} have different dimensions.");
        }
        int d = 0;
        for (int i = 0; i < c1.length; ++i) {
            d += (c1[i] - c2[i]) * (c1[i] - c2[i]);
        }
        return Math.sqrt(d);
    }

    private static int[] validateLocation(ILocation location) throws LocationException {
        if (location == null || location.getDimensions() != 3) {
            throw new LocationException("The location '" + location + "' does not have exactly three coordinated.");
        }
        return location.getCoordinates();
    }

    public static Block getBlock(World world, ILocation location) throws LocationException {
        int[] c = LocationHelpers.validateLocation(location);
        return world.func_147439_a(c[0], c[1], c[2]);
    }

    public static int getBlockMeta(World world, ILocation location) throws LocationException {
        int[] c = LocationHelpers.validateLocation(location);
        return world.func_72805_g(c[0], c[1], c[2]);
    }

    public static TileEntity getTile(IBlockAccess world, ILocation location) throws LocationException {
        int[] c = LocationHelpers.validateLocation(location);
        return world.func_147438_o(c[0], c[1], c[2]);
    }

    public static void setBlock(World world, ILocation location, Block block) throws LocationException {
        int[] c = LocationHelpers.validateLocation(location);
        world.func_147449_b(c[0], c[1], c[2], block);
    }

    public static void setBlockMetadata(World world, ILocation location, int meta, int notifyFlag) throws LocationException {
        int[] c = LocationHelpers.validateLocation(location);
        world.func_72921_c(c[0], c[1], c[2], meta, notifyFlag);
    }

    public static ILocation getRandomPointInSphere(ILocation center, int radius) {
        Location randomPoint = null;
        while (randomPoint == null) {
            int totalDistance = 0;
            int[] coordinates = new int[center.getDimensions()];
            for (int i = 0; i < center.getDimensions(); ++i) {
                coordinates[i] = center.getCoordinates()[i] - radius + random.nextInt(2 * radius);
                int d = center.getCoordinates()[i] - coordinates[i];
                totalDistance += d * d;
            }
            if ((int)Math.sqrt(totalDistance) > radius) continue;
            randomPoint = new Location(coordinates);
        }
        return randomPoint;
    }

    public static double getYaw(ILocation start, ILocation end) {
        int[] c1 = start.getCoordinates();
        int[] c2 = end.getCoordinates();
        double dX = c1[0] - c2[0];
        double dY = c1[1] - c2[1];
        double dZ = c1[2] - c2[2];
        return Math.atan2(dZ, dX) * 180.0 / Math.PI;
    }

    public static double getPitch(ILocation start, ILocation end) {
        int[] c1 = start.getCoordinates();
        int[] c2 = end.getCoordinates();
        double dX = c1[0] - c2[0];
        double dY = c1[1] - c2[1];
        double dZ = c1[2] - c2[2];
        return (Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI) * 180.0 / Math.PI;
    }

    public static class LocationException
    extends RuntimeException {
        public LocationException(String message) {
            super(message);
        }
    }
}

