/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.helper.obfuscation;

import cpw.mods.fml.relauncher.ReflectionHelper;
import evilcraft.core.helper.obfuscation.ObfuscationData;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ObfuscationHelpers {
    public static ResourceLocation getParticleTexture() {
        return (ResourceLocation)ReflectionHelper.getPrivateValue(EffectRenderer.class, null, (String[])ObfuscationData.PARTICLE_TEXTURES);
    }

    public static void setRecentlyHit(EntityLivingBase entity, int recentlyHit) {
        ReflectionHelper.setPrivateValue(EntityLivingBase.class, (Object)entity, (Object)recentlyHit, (String[])ObfuscationData.ENTITYLIVINGBASE_RECENTLYHIT);
    }

    public static String getDeathSound(EntityLivingBase entity) {
        Method method = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)entity, (String[])ObfuscationData.ENTITYLIVINGBASE_GETDEATHSOUND, (Class[])new Class[0]);
        try {
            return (String)method.invoke((Object)entity, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getLivingSound(EntityLiving entity) {
        Method method = ReflectionHelper.findMethod(EntityLiving.class, (Object)entity, (String[])ObfuscationData.ENTITYLIVING_GETLIVINGSOUND, (Class[])new Class[0]);
        try {
            return (String)method.invoke((Object)entity, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int getItemInUseCount(EntityPlayer player) {
        return (Integer)ReflectionHelper.getPrivateValue(EntityPlayer.class, (Object)player, (String[])ObfuscationData.ENTITYPLAYER_ITEMINUSECOUNT);
    }

    public static ItemStack getItemInUse(EntityPlayer player) {
        return (ItemStack)ReflectionHelper.getPrivateValue(EntityPlayer.class, (Object)player, (String[])ObfuscationData.ENTITYPLAYER_ITEMINUSE);
    }

    public static void setTitlePanoramaPaths(ResourceLocation[] titlePanoramaPaths) {
        Field field = ReflectionHelper.findField(GuiMainMenu.class, (String[])ObfuscationData.GUIMAINMENU_TITLEPANORAMAPATHS);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.setAccessible(true);
            field.set(null, titlePanoramaPaths);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Method getRenderFaceMethod(RenderBlocks renderer, ForgeDirection direction) {
        Method method = ReflectionHelper.findMethod(RenderBlocks.class, (Object)renderer, (String[])ObfuscationData.RENDERBLOCKS_RENDERFACE.get(direction), (Class[])new Class[]{Block.class, Double.TYPE, Double.TYPE, Double.TYPE, IIcon.class});
        return method;
    }

    public static void setUVRotate(RenderBlocks renderer, ForgeDirection direction, int rotation) {
        ReflectionHelper.setPrivateValue(RenderBlocks.class, (Object)renderer, (Object)rotation, (String[])ObfuscationData.RENDERBLOCKS_UVROTATE.get(direction));
    }

    public static void setPotionEffectDuration(PotionEffect potionEffect, int duration) {
        ReflectionHelper.setPrivateValue(PotionEffect.class, (Object)potionEffect, (Object)duration, (String[])ObfuscationData.POTIONEFFECT_DURATION);
    }

    public static void onChangedPotionEffect(EntityLivingBase entity, PotionEffect potionEffect, boolean reapplyAttributes) {
        Method method = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)entity, (String[])ObfuscationData.ENTITYLIVINGBASE_ONCHANGEDPOTIONEFFECT, (Class[])new Class[]{PotionEffect.class, Boolean.TYPE});
        try {
            method.invoke((Object)entity, potionEffect, reapplyAttributes);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Map<Class<Entity>, Integer> getClassToID() {
        return (Map)ReflectionHelper.getPrivateValue(EntityList.class, null, (String[])ObfuscationData.ENTITYLIST_CLASSTOID);
    }

    public static boolean isPotionBadEffect(Potion potion) {
        return (Boolean)ReflectionHelper.getPrivateValue(Potion.class, (Object)potion, (String[])ObfuscationData.POTION_ISBADEFFECT);
    }

    public static void setPotionTypesArray(Potion[] potionTypes) {
        Field field = ReflectionHelper.findField(Potion.class, (String[])ObfuscationData.POTION_POTIONTYPES);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.setAccessible(true);
            field.set(null, potionTypes);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static boolean isRainingEnabled(BiomeGenBase biome) {
        return (Boolean)ReflectionHelper.getPrivateValue(BiomeGenBase.class, (Object)biome, (String[])ObfuscationData.BIOME_ENABLERAIN);
    }

    public static int getShapedOreRecipeWidth(ShapedOreRecipe recipe) {
        return (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)recipe, (String[])ObfuscationData.SHAPEDORERECIPE_WIDTH);
    }

    public static int getShapedOreRecipeHeight(ShapedOreRecipe recipe) {
        return (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)recipe, (String[])ObfuscationData.SHAPEDORERECIPE_HEIGHT);
    }
}

