/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.inventory;

import evilcraft.core.helper.InventoryHelpers;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class NBTCraftingGrid
extends InventoryCrafting {
    private static final String NBT_TAG_ROOT = "CraftingGridInventory";
    protected EntityPlayer player;
    protected int itemIndex;

    public NBTCraftingGrid(EntityPlayer player, int itemIndex, Container eventHandler) {
        super(eventHandler, 3, 3);
        ItemStack itemStack = InventoryHelpers.getItemFromIndex(player, itemIndex);
        this.player = player;
        this.itemIndex = itemIndex;
        InventoryHelpers.validateNBTStorage((IInventory)this, itemStack, NBT_TAG_ROOT);
    }

    public void save() {
        ItemStack itemStack = InventoryHelpers.getItemFromIndex(this.player, this.itemIndex);
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        this.writeToNBT(tag, NBT_TAG_ROOT);
        itemStack.func_77982_d(tag);
    }

    protected void readFromNBT(NBTTagCompound data, String tagName) {
        InventoryHelpers.readFromNBT((IInventory)this, data, tagName);
    }

    protected void writeToNBT(NBTTagCompound data, String tagName) {
        InventoryHelpers.writeToNBT((IInventory)this, data, tagName);
    }
}

