/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.block.IBlockTank;
import evilcraft.core.helper.Helpers;
import evilcraft.core.helper.ItemHelpers;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.core.item.ItemBlockNBT;
import evilcraft.core.tileentity.TankInventoryTileEntity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemBlockFluidContainer
extends ItemBlockNBT
implements IFluidContainerItem {
    private IBlockTank block;

    public ItemBlockFluidContainer(Block block) {
        super(block);
        this.block = (IBlockTank)block;
    }

    public IBlockTank getBlockTank() {
        return this.block;
    }

    public FluidStack getFluid(ItemStack container) {
        String key = this.block.getTankNBTName();
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b(key)) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l(key));
    }

    protected void setFluid(ItemStack container, FluidStack fluidStack) {
        String key = this.block.getTankNBTName();
        if (fluidStack == null || fluidStack.amount <= 0) {
            container.field_77990_d.func_82580_o(key);
            if (container.field_77990_d.func_82582_d()) {
                container.field_77990_d = null;
            }
        } else {
            if (container.field_77990_d == null) {
                container.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound fluidTag = container.field_77990_d.func_74775_l(key);
            fluidStack.writeToNBT(fluidTag);
            fluidTag.func_82580_o("Empty");
            container.field_77990_d.func_74782_a(key, (NBTBase)fluidTag);
        }
    }

    public int getCapacity(ItemStack container) {
        return this.block.getTankCapacity(container);
    }

    public void setCapacity(ItemStack container, int capacity) {
        this.block.setTankCapacity(container, capacity);
    }

    @Override
    protected void readAdditionalInfo(TileEntity tile, ItemStack itemStack) {
        super.readAdditionalInfo(tile, itemStack);
        if (tile instanceof TankInventoryTileEntity) {
            TankInventoryTileEntity tankTile = (TankInventoryTileEntity)tile;
            tankTile.getTank().setCapacity(this.getCapacity(itemStack));
        }
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        int capacity = this.getCapacity(container);
        if (resource == null) {
            return 0;
        }
        FluidStack stack = this.getFluid(container);
        if (!doFill) {
            if (stack == null) {
                return Math.min(capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - stack.amount, resource.amount);
        }
        if (stack == null) {
            stack = resource.copy();
            stack.amount = 0;
        }
        if (!resource.isFluidEqual(stack)) {
            return 0;
        }
        int filled = capacity - stack.amount;
        if (resource.amount < filled) {
            stack.amount = Helpers.addSafe(stack.amount, resource.amount);
            filled = resource.amount;
        } else {
            stack.amount = capacity;
        }
        this.setFluid(container, stack);
        return filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        FluidStack stack = this.getFluid(container);
        if (stack == null) {
            return null;
        }
        int currentAmount = stack.amount;
        stack.amount = Math.min(stack.amount, maxDrain);
        if (doDrain) {
            FluidStack newStack = stack.copy();
            newStack.amount = currentAmount - stack.amount;
            this.setFluid(container, newStack);
        }
        return stack;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (this.block.isActivatable()) {
            return this.block.toggleActivation(itemStack, world, player);
        }
        return super.func_77659_a(itemStack, world, player);
    }

    protected void autofill(IFluidContainerItem item, ItemStack itemStack, World world, Entity entity) {
        ItemHelpers.updateAutoFill(this, itemStack, world, entity);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (this.block.isActivatable() && this.block.isActivated(itemStack, world, entity)) {
            this.autofill(this, itemStack, world, entity);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        if (this.block.isActivatable()) {
            L10NHelpers.addStatusInfo(list, this.block.isActivated(itemStack, entityPlayer.field_70170_p, (Entity)entityPlayer), this.func_77658_a() + ".info.autoSupply");
        }
    }
}

