/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.recipe;

import evilcraft.block.DarkTank;
import evilcraft.core.helper.Helpers;
import evilcraft.core.item.ItemBlockFluidContainer;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ItemBlockFluidContainerCombinationRecipe
implements IRecipe {
    private int size;
    private ItemBlockFluidContainer tankItem;

    public ItemBlockFluidContainerCombinationRecipe(int size, ItemBlockFluidContainer tankItem) {
        this.size = size;
        this.tankItem = tankItem;
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        return this.func_77572_b(grid) != null;
    }

    public int func_77570_a() {
        return this.size;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Block)DarkTank.getInstance());
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        ItemStack output = this.func_77571_b().func_77946_l();
        Fluid commonFluid = null;
        int totalCapacity = 0;
        int totalContent = 0;
        int inputItems = 0;
        for (int j = 0; j < grid.func_70302_i_(); ++j) {
            ItemStack element = grid.func_70301_a(j);
            if (element == null) continue;
            if (element.func_77973_b() == this.tankItem) {
                ++inputItems;
                FluidStack fluidStack = this.tankItem.getFluid(element);
                if (fluidStack != null) {
                    if (commonFluid == null) {
                        commonFluid = fluidStack.getFluid();
                    } else if (!commonFluid.equals(fluidStack.getFluid())) {
                        return null;
                    }
                    totalContent = Helpers.addSafe(totalContent, fluidStack.amount);
                }
                totalCapacity = Helpers.addSafe(totalCapacity, this.tankItem.getCapacity(element));
                continue;
            }
            return null;
        }
        if (inputItems < 2 || totalCapacity > this.tankItem.getBlockTank().getMaxCapacity()) {
            return null;
        }
        this.tankItem.setCapacity(output, totalCapacity);
        if (commonFluid != null) {
            this.tankItem.fill(output, new FluidStack(commonFluid, totalContent), true);
        }
        return output;
    }
}

