/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.recipe.custom;

import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.api.recipes.custom.IRecipeInput;
import evilcraft.api.recipes.custom.IRecipeOutput;
import evilcraft.api.recipes.custom.IRecipeProperties;
import java.beans.ConstructorProperties;

public class Recipe<I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties>
implements IRecipe<I, O, P> {
    private final String namedId;
    private final I input;
    private final O output;
    private final P properties;

    public Recipe(I input, O output) {
        this.input = input;
        this.output = output;
        this.properties = null;
        this.namedId = this.generateNamedId();
    }

    public Recipe(I input, O output, P properties) {
        this.input = input;
        this.output = output;
        this.properties = properties;
        this.namedId = this.generateNamedId();
    }

    private String generateNamedId() {
        String namedId = this.input.getClass().getName() + "_" + this.output.getClass().getName() + "_";
        if (this.properties != null) {
            namedId = namedId + this.properties.getClass().getName() + "_";
        }
        namedId = namedId + Integer.toString(this.input.hashCode()) + Integer.toString(this.output.hashCode());
        if (this.properties != null) {
            namedId = namedId + Integer.toString(this.properties.hashCode());
        }
        return namedId;
    }

    @ConstructorProperties(value={"namedId", "input", "output", "properties"})
    public Recipe(String namedId, I input, O output, P properties) {
        this.namedId = namedId;
        this.input = input;
        this.output = output;
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Recipe)) {
            return false;
        }
        Recipe other = (Recipe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$namedId = this.getNamedId();
        String other$namedId = other.getNamedId();
        if (this$namedId == null ? other$namedId != null : !this$namedId.equals(other$namedId)) {
            return false;
        }
        I this$input = this.getInput();
        I other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        O this$output = this.getOutput();
        O other$output = other.getOutput();
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        P this$properties = this.getProperties();
        P other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Recipe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namedId = this.getNamedId();
        result = result * 59 + ($namedId == null ? 0 : $namedId.hashCode());
        I $input = this.getInput();
        result = result * 59 + ($input == null ? 0 : $input.hashCode());
        O $output = this.getOutput();
        result = result * 59 + ($output == null ? 0 : $output.hashCode());
        P $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 0 : $properties.hashCode());
        return result;
    }

    @Override
    public String getNamedId() {
        return this.namedId;
    }

    @Override
    public I getInput() {
        return this.input;
    }

    @Override
    public O getOutput() {
        return this.output;
    }

    @Override
    public P getProperties() {
        return this.properties;
    }
}

