/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.recipe.xml;

import com.google.common.collect.Maps;
import evilcraft.core.recipe.xml.DefaultItemTypeHandler;
import evilcraft.core.recipe.xml.IItemTypeHandler;
import evilcraft.core.recipe.xml.IRecipeTypeHandler;
import evilcraft.core.recipe.xml.OreDictItemTypeHandler;
import evilcraft.core.recipe.xml.PredefinedItemTypeHandler;
import evilcraft.core.recipe.xml.XmlRecipeLoader;
import java.util.Map;
import org.w3c.dom.Node;

public abstract class CommonRecipeTypeHandler
implements IRecipeTypeHandler,
IItemTypeHandler {
    private static final Map<String, IItemTypeHandler> ITEM_TYPE_HANDLERS = Maps.newHashMap();
    protected static final String DEFAULT_ITEM_TYPE = "default";

    public static void registerItemTypeHandler(String type, IItemTypeHandler handler) {
        ITEM_TYPE_HANDLERS.put(type, handler);
    }

    @Override
    public Object getItem(Node itemNode) throws XmlRecipeLoader.XmlRecipeException {
        String type = DEFAULT_ITEM_TYPE;
        Node typeAttribute = itemNode.getAttributes().getNamedItem("type");
        if (typeAttribute != null) {
            type = typeAttribute.getTextContent();
        }
        return this.getItem(itemNode, type);
    }

    protected Object getItem(Node itemNode, String type) throws XmlRecipeLoader.XmlRecipeException {
        IItemTypeHandler handler = ITEM_TYPE_HANDLERS.get(type);
        if (handler == null) {
            throw new XmlRecipeLoader.XmlRecipeException(String.format("Could not find an item type handler of type '%s'", type));
        }
        return handler.getItem(itemNode);
    }

    static {
        ITEM_TYPE_HANDLERS.put(DEFAULT_ITEM_TYPE, new DefaultItemTypeHandler());
        ITEM_TYPE_HANDLERS.put("oredict", new OreDictItemTypeHandler());
        ITEM_TYPE_HANDLERS.put("predefined", new PredefinedItemTypeHandler());
    }
}

