/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.recipe.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import evilcraft.Configs;
import evilcraft.EvilCraft;
import evilcraft.Recipes;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.recipe.xml.BloodInfuserRecipeTypeHandler;
import evilcraft.core.recipe.xml.ConfigRecipeConditionHandler;
import evilcraft.core.recipe.xml.EnvironmentalAccumulatorRecipeTypeHandler;
import evilcraft.core.recipe.xml.IRecipeConditionHandler;
import evilcraft.core.recipe.xml.IRecipeTypeHandler;
import evilcraft.core.recipe.xml.ModRecipeConditionHandler;
import evilcraft.core.recipe.xml.PredefinedRecipeConditionHandler;
import evilcraft.core.recipe.xml.ShapedRecipeTypeHandler;
import evilcraft.core.recipe.xml.ShapelessRecipeTypeHandler;
import evilcraft.core.recipe.xml.SmeltingRecipeTypeHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlRecipeLoader {
    private static final Map<String, IRecipeTypeHandler> RECIPE_TYPE_HANDLERS = Maps.newHashMap();
    public static final Map<String, IRecipeConditionHandler> RECIPE_CONDITION_HANDLERS;
    private static final Map<String, ItemStack> PREDEFINED_ITEMS;
    private static final Set<String> PREDEFINED_VALUES;
    private StreamSource stream;
    private String fileName;
    private InputStream xsdIs = null;
    private Document doc = null;

    public static void registerRecipeTypeHandler(String type, IRecipeTypeHandler handler) {
        RECIPE_TYPE_HANDLERS.put(type, handler);
    }

    public static void registerRecipeConditionHandler(String type, IRecipeConditionHandler handler) {
        RECIPE_CONDITION_HANDLERS.put(type, handler);
    }

    public static void registerPredefinedItem(String key, ItemStack item) {
        PREDEFINED_ITEMS.put(key, item);
    }

    public static ItemStack getPredefinedItem(String key) {
        return PREDEFINED_ITEMS.get(key);
    }

    public static void registerPredefinedValue(String value) {
        PREDEFINED_VALUES.add(value);
    }

    public static boolean isPredefinedValue(String value) {
        return PREDEFINED_VALUES.contains(value);
    }

    public XmlRecipeLoader(InputStream is, String fileName) {
        this.stream = new StreamSource(is);
        this.fileName = fileName;
    }

    public void setValidator(InputStream xsdIs) {
        this.xsdIs = xsdIs;
    }

    public void validate() throws XmlRecipeException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            if (this.xsdIs != null) {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                factory.setErrorHandler(new ErrorHandler(){

                    @Override
                    public void warning(SAXParseException exception) throws SAXException {
                        EvilCraft.log("[" + XmlRecipeLoader.this.fileName + "]: " + exception.getMessage(), Level.WARN);
                    }

                    @Override
                    public void fatalError(SAXParseException exception) throws SAXException {
                        EvilCraft.log("[" + XmlRecipeLoader.this.fileName + "]: " + exception.getMessage(), Level.FATAL);
                    }

                    @Override
                    public void error(SAXParseException exception) throws SAXException {
                        EvilCraft.log("[" + XmlRecipeLoader.this.fileName + "]: " + exception.getMessage(), Level.ERROR);
                    }
                });
                Schema schema = factory.newSchema(new StreamSource(this.xsdIs));
                dbFactory.setSchema(schema);
            }
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            this.doc = dBuilder.parse(this.stream.getInputStream());
        }
        catch (SAXException e) {
            throw new XmlRecipeException(e);
        }
        catch (IOException e) {
            throw new XmlRecipeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new XmlRecipeException(e);
        }
    }

    public void loadRecipes(boolean crashOnInvalidRecipe) throws XmlRecipeException {
        if (this.doc == null) {
            this.validate();
        }
        NodeList recipes = this.doc.getElementsByTagName("recipe");
        for (int i = 0; i < recipes.getLength(); ++i) {
            Element recipe = (Element)recipes.item(i);
            if (!this.isRecipeEnabled(recipe)) continue;
            try {
                this.handleRecipe(recipe);
                continue;
            }
            catch (XmlRecipeException e) {
                if (crashOnInvalidRecipe) {
                    throw e;
                }
                EvilCraft.log(e.getMessage(), Level.ERROR);
            }
        }
    }

    private boolean isRecipeEnabled(Element recipe) {
        boolean enable = true;
        NodeList conditions = recipe.getElementsByTagName("condition");
        for (int j = 0; j < conditions.getLength() && enable; ++j) {
            Node condition = conditions.item(j);
            String conditionType = condition.getAttributes().getNamedItem("type").getTextContent();
            IRecipeConditionHandler handler = RECIPE_CONDITION_HANDLERS.get(conditionType);
            if (handler == null) {
                throw new XmlRecipeException(String.format("Could not find a recipe condition handler of type '%s'", conditionType));
            }
            String param = condition.getTextContent();
            enable = enable && handler.isSatisfied(param);
        }
        return enable;
    }

    private void handleRecipe(Element recipe) throws XmlRecipeException {
        String type = recipe.getAttributes().getNamedItem("type").getTextContent();
        IRecipeTypeHandler handler = RECIPE_TYPE_HANDLERS.get(type);
        if (handler == null) {
            throw new XmlRecipeException(String.format("Could not find a recipe type handler of type '%s'", type));
        }
        ItemStack output = handler.loadRecipe(recipe);
        ExtendedConfig<?> config = Configs.getConfigFromItem(output.func_77973_b());
        for (String tag : this.getTags(recipe)) {
            Recipes.taggedOutput.put((Object)tag, (Object)output);
            Recipes.taggedConfigurablesOutput.put((Object)tag, config);
        }
    }

    private List<String> getTags(Element recipe) {
        NodeList tagNodes = recipe.getElementsByTagName("tag");
        ArrayList tags = Lists.newArrayListWithCapacity((int)tagNodes.getLength());
        for (int i = 0; i < tagNodes.getLength(); ++i) {
            Element tag = (Element)tagNodes.item(i);
            tags.add(tag.getTextContent());
        }
        return tags;
    }

    static {
        RECIPE_TYPE_HANDLERS.put("shaped", new ShapedRecipeTypeHandler());
        RECIPE_TYPE_HANDLERS.put("shapeless", new ShapelessRecipeTypeHandler());
        RECIPE_TYPE_HANDLERS.put("smelting", new SmeltingRecipeTypeHandler());
        RECIPE_TYPE_HANDLERS.put("evilcraft:bloodinfuser", new BloodInfuserRecipeTypeHandler());
        RECIPE_TYPE_HANDLERS.put("evilcraft:environmentalaccumulator", new EnvironmentalAccumulatorRecipeTypeHandler());
        RECIPE_CONDITION_HANDLERS = Maps.newHashMap();
        RECIPE_CONDITION_HANDLERS.put("config", new ConfigRecipeConditionHandler());
        RECIPE_CONDITION_HANDLERS.put("predefined", new PredefinedRecipeConditionHandler());
        RECIPE_CONDITION_HANDLERS.put("mod", new ModRecipeConditionHandler());
        PREDEFINED_ITEMS = Maps.newHashMap();
        PREDEFINED_VALUES = Sets.newHashSet();
    }

    public static class XmlRecipeException
    extends RuntimeException {
        public XmlRecipeException(String message) {
            super(message);
        }

        public XmlRecipeException(Exception e) {
            super(e.getMessage());
        }
    }
}

