/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.tileentity;

import evilcraft.core.config.configurable.ConfigurableBlockContainer;
import evilcraft.core.tileentity.NBTClassType;
import evilcraft.core.tileentity.NBTPersist;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EvilCraftTileEntity
extends TileEntity {
    private static final int UPDATE_BACKOFF_TICKS = 1;
    private List<Field> nbtPersistedFields = null;
    @NBTPersist
    private Boolean rotatable = false;
    private ForgeDirection rotation = ForgeDirection.NORTH;
    private boolean shouldSendUpdate = false;
    private int sendUpdateBackoff = (int)Math.round(Math.random() * (double)this.getUpdateBackoffTicks());

    public EvilCraftTileEntity() {
        this.generateNBTPersistedFields();
    }

    public void destroy() {
        this.func_145843_s();
    }

    public boolean canInteractWith(EntityPlayer entityPlayer) {
        return true;
    }

    public final void sendUpdate() {
        this.shouldSendUpdate = true;
    }

    public final void sendImmediateUpdate() {
        this.sendUpdate();
        this.sendUpdateBackoff = 0;
    }

    public final void func_145845_h() {
        super.func_145845_h();
        this.updateTileEntity();
        this.trySendActualUpdate();
    }

    protected void updateTileEntity() {
    }

    private void trySendActualUpdate() {
        --this.sendUpdateBackoff;
        if (this.sendUpdateBackoff <= 0) {
            this.sendUpdateBackoff = this.getUpdateBackoffTicks();
            if (this.shouldSendUpdate && this.isTileValid()) {
                this.shouldSendUpdate = false;
                this.beforeSendUpdate();
                this.onSendUpdate();
                this.afterSendUpdate();
            }
        }
    }

    protected boolean isTileValid() {
        return this.func_145838_q() instanceof ConfigurableBlockContainer;
    }

    protected void onSendUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected void beforeSendUpdate() {
    }

    protected void afterSendUpdate() {
    }

    public Packet func_145844_m() {
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, this.getNBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound tag = packet.func_148857_g();
        this.func_145839_a(tag);
        this.onUpdateReceived();
    }

    private void generateNBTPersistedFields() {
        this.nbtPersistedFields = new LinkedList<Field>();
        for (Class<?> clazz = ((Object)((Object)this)).getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(NBTPersist.class)) continue;
                this.nbtPersistedFields.add(field);
            }
        }
    }

    private void writePersistedField(Field field, NBTTagCompound tag) {
        NBTClassType.performActionForField(this, field, tag, true);
    }

    private void readPersistedField(Field field, NBTTagCompound tag) {
        NBTClassType.performActionForField(this, field, tag, false);
    }

    public void func_145841_b(NBTTagCompound NBTTagCompound2) {
        super.func_145841_b(NBTTagCompound2);
        for (Field field : this.nbtPersistedFields) {
            this.writePersistedField(field, NBTTagCompound2);
        }
        NBTTagCompound2.func_74768_a("rotation", this.rotation.ordinal());
    }

    public void func_145839_a(NBTTagCompound NBTTagCompound2) {
        super.func_145839_a(NBTTagCompound2);
        for (Field field : this.nbtPersistedFields) {
            this.readPersistedField(field, NBTTagCompound2);
        }
        ForgeDirection foundRotation = ForgeDirection.getOrientation((int)NBTTagCompound2.func_74762_e("rotation"));
        if (foundRotation != ForgeDirection.UNKNOWN) {
            this.rotation = foundRotation;
        }
        this.onLoad();
    }

    public void onLoad() {
    }

    public NBTTagCompound getNBTTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return tag;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public ForgeDirection getRotation() {
        return this.rotation;
    }

    public void setRotation(ForgeDirection rotation) {
        this.rotation = rotation;
    }

    public ConfigurableBlockContainer getBlock() {
        return (ConfigurableBlockContainer)this.func_145838_q();
    }

    public void onUpdateReceived() {
    }

    protected int getUpdateBackoffTicks() {
        return 1;
    }
}

