/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.tileentity;

import evilcraft.api.tileentity.INBTSerializable;
import evilcraft.core.tileentity.EvilCraftTileEntity;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class NBTClassType<T> {
    public static Map<Class<?>, NBTClassType<?>> NBTYPES = new HashMap();

    private static boolean isImplementsInterface(Class<?> clazz, Class<?> interfaceClazz) {
        try {
            clazz.asSubclass(interfaceClazz);
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static void performActionForField(EvilCraftTileEntity tile, Field field, NBTTagCompound tag, boolean write) {
        type = field.getType();
        fieldName = field.getName();
        wasAccessible = field.isAccessible();
        field.setAccessible(true);
        if (NBTClassType.isImplementsInterface(type, INBTSerializable.class)) {
            try {
                if (write) {
                    method = type.getMethod("toNBT", new Class[0]);
                    tag.func_74782_a(fieldName, (NBTBase)method.invoke(field.get((Object)tile), new Object[0]));
                }
                method = type.getMethod("fromNBT", new Class[]{NBTTagCompound.class});
                if (!tag.func_74764_b(fieldName)) ** GOTO lbl39
                method.invoke(field.get((Object)tile), new Object[]{tag.func_74781_a(fieldName)});
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No such method for field " + fieldName + " of class " + type + " in " + tile.getClass() + " was found. Write: " + write);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not access field " + fieldName + " in " + tile.getClass() + " Write: " + write);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Invalid argument in field " + fieldName + " in " + tile.getClass() + " Write: " + write);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Could not invocate a method for field " + fieldName + " in " + tile.getClass() + " Write: " + write + "; Error: " + e.getTargetException().getMessage());
            }
        } else {
            action = NBTClassType.NBTYPES.get(type);
            if (action != null) {
                try {
                    modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(field, field.getModifiers() & -17);
                    field.setAccessible(true);
                    action.persistedFieldAction(tile, field, tag, write);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Could not access field " + fieldName + " in " + tile.getClass());
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            } else {
                throw new RuntimeException("No NBT persist action found for field " + fieldName + " of class " + type + " in " + tile.getClass());
            }
        }
lbl39:
        // 5 sources

        field.setAccessible(wasAccessible);
    }

    public void persistedFieldAction(EvilCraftTileEntity tile, Field field, NBTTagCompound tag, boolean write) throws IllegalAccessException {
        block7: {
            String name = field.getName();
            Object castTile = field.getDeclaringClass().cast((Object)tile);
            if (write) {
                try {
                    Object object = field.get(castTile);
                    try {
                        this.writePersistedField(name, object, tag);
                        break block7;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Something went from with field " + field.getName() + " in " + castTile + ": " + e.getMessage());
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Can not write the field " + field.getName() + " in " + castTile + " since it does not exist.");
                }
            }
            Object object = null;
            try {
                object = this.readPersistedField(name, tag);
                field.set(castTile, object);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Can not read the field " + field.getName() + " as " + object + " in " + castTile + " since it does not exist OR there is a class mismatch.");
            }
        }
    }

    protected abstract void writePersistedField(String var1, T var2, NBTTagCompound var3);

    protected abstract T readPersistedField(String var1, NBTTagCompound var2);

    static {
        NBTYPES.put(Integer.class, new NBTClassType<Integer>(){

            @Override
            protected void writePersistedField(String name, Integer object, NBTTagCompound tag) {
                tag.func_74768_a(name, object.intValue());
            }

            @Override
            protected Integer readPersistedField(String name, NBTTagCompound tag) {
                return tag.func_74762_e(name);
            }
        });
        NBTYPES.put(Float.class, new NBTClassType<Float>(){

            @Override
            protected void writePersistedField(String name, Float object, NBTTagCompound tag) {
                tag.func_74776_a(name, object.floatValue());
            }

            @Override
            protected Float readPersistedField(String name, NBTTagCompound tag) {
                return Float.valueOf(tag.func_74760_g(name));
            }
        });
        NBTYPES.put(Boolean.class, new NBTClassType<Boolean>(){

            @Override
            protected void writePersistedField(String name, Boolean object, NBTTagCompound tag) {
                tag.func_74757_a(name, object.booleanValue());
            }

            @Override
            protected Boolean readPersistedField(String name, NBTTagCompound tag) {
                return tag.func_74767_n(name);
            }
        });
        NBTYPES.put(String.class, new NBTClassType<String>(){

            @Override
            protected void writePersistedField(String name, String object, NBTTagCompound tag) {
                if (object != null && !object.isEmpty()) {
                    tag.func_74778_a(name, object);
                }
            }

            @Override
            protected String readPersistedField(String name, NBTTagCompound tag) {
                return tag.func_74779_i(name);
            }
        });
        NBTYPES.put(NBTTagCompound.class, new NBTClassType<NBTTagCompound>(){

            @Override
            protected void writePersistedField(String name, NBTTagCompound object, NBTTagCompound tag) {
                tag.func_74782_a(name, (NBTBase)object);
            }

            @Override
            protected NBTTagCompound readPersistedField(String name, NBTTagCompound tag) {
                return tag.func_74775_l(name);
            }
        });
    }
}

