/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.tileentity;

import evilcraft.core.fluid.SingleUseTank;
import evilcraft.core.tileentity.InventoryTileEntity;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class TankInventoryTileEntity
extends InventoryTileEntity
implements IFluidHandler {
    private SingleUseTank tank;
    protected int tankSize;
    private String tankName;
    private Fluid acceptedFluid = null;
    protected boolean sendUpdateOnTankChanged = false;

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName, int stackSize) {
        super(inventorySize, inventoryName, stackSize);
        this.tankSize = tankSize;
        this.tankName = tankName;
        this.setSendUpdateOnTankChanged(true);
        this.tank = this.newTank(tankName, tankSize);
    }

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName) {
        this(inventorySize, inventoryName, tankSize, tankName, 64);
    }

    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new SingleUseTank(tankName, tankSize, this);
    }

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int stackSize, int tankSize, String tankName) {
        super(inventorySize, inventoryName, stackSize);
        this.tankSize = tankSize;
        this.tankName = tankName;
        this.setSendUpdateOnTankChanged(true);
        this.tank = this.newTank(tankName, tankSize);
    }

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName, Fluid acceptedFluid) {
        this(inventorySize, inventoryName, tankSize, tankName);
        this.tankSize = tankSize;
        this.tankName = tankName;
        this.acceptedFluid = acceptedFluid;
        this.tank.setAcceptedFluid(acceptedFluid);
    }

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int stackSize, int tankSize, String tankName, Fluid acceptedFluid) {
        this(inventorySize, inventoryName, stackSize, tankSize, tankName);
        this.tankSize = tankSize;
        this.tankName = tankName;
        this.acceptedFluid = acceptedFluid;
        this.tank.setAcceptedFluid(acceptedFluid);
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tank.readFromNBT(data);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tank.writeToNBT(data);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.fill(ForgeDirection.UP, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.drain(ForgeDirection.DOWN, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(ForgeDirection.DOWN, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.getAcceptedFluid() == null || this.tank.canTankAccept(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank.getAcceptedFluid() == null || this.tank.canTankAccept(fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] info = new FluidTankInfo[]{this.tank.getInfo()};
        return info;
    }

    public boolean isSendUpdateOnTankChanged() {
        return this.sendUpdateOnTankChanged;
    }

    public void setSendUpdateOnTankChanged(boolean sendUpdateOnTankChanged) {
        this.sendUpdateOnTankChanged = sendUpdateOnTankChanged;
    }

    @Override
    protected void onSendUpdate() {
        super.onSendUpdate();
        if (this.getBlock().func_149740_M()) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)this.getBlock());
        }
    }
}

