/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.world.gen;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import evilcraft.EvilCraft;
import evilcraft.GeneralConfig;
import evilcraft.core.world.gen.IRetroGen;
import java.util.Random;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import org.apache.logging.log4j.Level;

public class RetroGenRegistry {
    private static final String NBT_TAG_RETROGENERATED = "EvilCraft-RetroGen";
    private static RetroGenRegistry _instance = null;
    private Set<IRetroGen> retroGeneratables = Sets.newHashSet();
    private Random random = new Random();

    private RetroGenRegistry() {
    }

    public static RetroGenRegistry getInstance() {
        if (_instance == null) {
            _instance = new RetroGenRegistry();
        }
        return _instance;
    }

    public void registerRetroGen(IRetroGen retroGen) {
        this.retroGeneratables.add(retroGen);
    }

    @SubscribeEvent
    public void retroGenLoad(ChunkDataEvent.Load event) {
        if (GeneralConfig.retrogen && event.getData() != null) {
            NBTTagCompound tag = event.getData().func_74775_l(NBT_TAG_RETROGENERATED);
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.setChunkSeed(event.world, event.getChunk());
            boolean atLeastOneModified = false;
            for (IRetroGen retroGen : this.retroGeneratables) {
                if (!retroGen.shouldRetroGen(tag, event.world.field_73011_w.field_76574_g)) continue;
                retroGen.retroGenerateChunk(tag, event.getChunk(), this.random);
                EvilCraft.log("Retrogenerating chunk at " + event.getChunk().field_76635_g + ":" + event.getChunk().field_76647_h, Level.INFO);
                atLeastOneModified = true;
            }
            if (atLeastOneModified) {
                event.getChunk().func_76630_e();
            }
        }
    }

    private void setChunkSeed(World world, Chunk chunk) {
        this.random.setSeed(world.func_72905_C());
        long xSeed = this.random.nextLong() >> 3;
        long zSeed = this.random.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunk.field_76635_g + zSeed * (long)chunk.field_76647_h ^ world.func_72905_C();
        this.random.setSeed(chunkSeed);
    }

    @SubscribeEvent
    public void retroGenSave(ChunkDataEvent.Save event) {
        if (GeneralConfig.retrogen && event.getData() != null) {
            NBTTagCompound tag = event.getData().func_74775_l(NBT_TAG_RETROGENERATED);
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            for (IRetroGen retroGen : this.retroGeneratables) {
                retroGen.afterRetroGen(tag);
            }
            event.getData().func_74782_a(NBT_TAG_RETROGENERATED, (NBTBase)tag);
        }
    }
}

