/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.entity.monster;

import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.EvilCraft;
import evilcraft.IInitListener;
import evilcraft.client.render.entity.RenderVengeanceSpirit;
import evilcraft.core.IMCHandler;
import evilcraft.core.config.ConfigurableProperty;
import evilcraft.core.config.ConfigurableTypeCategory;
import evilcraft.core.config.extendedconfig.MobConfig;
import evilcraft.core.helper.RenderHelpers;
import evilcraft.entity.monster.VengeanceSpirit;
import net.minecraft.client.renderer.entity.Render;
import org.apache.logging.log4j.Level;

public class VengeanceSpiritConfig
extends MobConfig {
    public static VengeanceSpiritConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MOB, comment="Should the Vengeance Spirit be enabled?", requiresMcRestart=true)
    public static boolean isEnabled;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MOB, comment="The maximum amount of vengeance spirits naturally spawnable in the spawnLimitArea.")
    public static int spawnLimit;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MOB, comment="The area in which the spawn limit will be checked on each spawn attempt.")
    public static int spawnLimitArea;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MOB, comment="The blacklisted entity spirits, by entity name.", changedCallback=VengeanceSpirit.SpiritBlacklistChanged.class)
    public static String[] entityBlacklist;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MOB, comment="The 1/X chance that an actual spirit will spawn when doing actions like mining with the Vengeance Pickaxe.")
    public static int nonDegradedSpawnChance;

    public VengeanceSpiritConfig() {
        super(true, "vengeanceSpirit", null, VengeanceSpirit.class);
    }

    @Override
    public boolean isEnabled() {
        return isEnabled;
    }

    @Override
    public int getBackgroundEggColor() {
        return RenderHelpers.RGBToInt(64, 16, 93);
    }

    @Override
    public int getForegroundEggColor() {
        return RenderHelpers.RGBToInt(134, 60, 169);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Render getRender() {
        return new RenderVengeanceSpirit(this);
    }

    @Override
    public void onInit(IInitListener.Step step) {
        super.onInit(step);
        if (step == IInitListener.Step.INIT) {
            EvilCraft.IMC_HANDLER.registerAction("blacklistVengeanceSpirit", new IMCHandler.IIMCAction(){

                @Override
                public boolean handle(FMLInterModComms.IMCMessage message) {
                    if (!message.isStringMessage()) {
                        return false;
                    }
                    try {
                        Class<?> clazz = Class.forName(message.getStringValue());
                        VengeanceSpirit.addToBlacklistIMC(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        EvilCraft.log("IMC blacklist vengeance spirit did not provide an existing class.", Level.ERROR);
                        return false;
                    }
                    catch (ClassCastException e) {
                        EvilCraft.log("IMC blacklist vengeance spirit did not provide a class of type EntityLivingBase.", Level.ERROR);
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    static {
        isEnabled = true;
        spawnLimit = 5;
        spawnLimitArea = 5;
        entityBlacklist = new String[]{"werewolf"};
        nonDegradedSpawnChance = 5;
    }
}

