/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.event;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import evilcraft.Configs;
import evilcraft.ExtendedDamageSource;
import evilcraft.block.BloodStainedBlock;
import evilcraft.block.BloodStainedBlockConfig;
import evilcraft.block.SpiritPortal;
import evilcraft.block.SpiritPortalConfig;
import evilcraft.client.particle.EntityBloodSplashFX;
import evilcraft.core.PlayerExtendedInventoryIterator;
import evilcraft.core.algorithm.Location;
import evilcraft.core.world.FakeWorld;
import evilcraft.entity.monster.VengeanceSpirit;
import evilcraft.entity.monster.VengeanceSpiritConfig;
import evilcraft.item.BloodExtractor;
import evilcraft.item.BloodExtractorConfig;
import evilcraft.item.VeinSword;
import evilcraft.item.VeinSwordConfig;
import evilcraft.item.VengeanceRing;
import evilcraft.item.VengeanceRingConfig;
import evilcraft.item.WerewolfFlesh;
import evilcraft.item.WerewolfFleshConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class LivingDeathEventHook {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingDeath(LivingDeathEvent event) {
        this.bloodObtainEvent(event);
        this.bloodStainedBlockEvent(event);
        this.vengeanceEvent(event);
        this.dropHumanoidFleshEvent(event);
        this.palingDeath(event);
    }

    private void bloodObtainEvent(LivingDeathEvent event) {
        Entity e = event.source.func_76346_g();
        if (e != null && e instanceof EntityPlayerMP && !e.field_70170_p.field_72995_K && event.entityLiving != null && Configs.isEnabled(BloodExtractorConfig.class)) {
            float boost = 1.0f;
            EntityPlayerMP player = (EntityPlayerMP)e;
            if (Configs.isEnabled(VeinSwordConfig.class) && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == VeinSword.getInstance()) {
                boost = (float)VeinSwordConfig.extractionBoost;
            }
            float health = event.entityLiving.func_110138_aP();
            int minimumMB = MathHelper.func_76141_d((float)(health * (float)BloodExtractorConfig.minimumMobMultiplier * boost));
            int maximumMB = MathHelper.func_76141_d((float)(health * (float)BloodExtractorConfig.maximumMobMultiplier * boost));
            BloodExtractor.getInstance().fillForAllBloodExtractors((EntityPlayer)player, minimumMB, maximumMB);
        }
    }

    private void bloodStainedBlockEvent(LivingDeathEvent event) {
        if (event.source == DamageSource.field_76379_h && Configs.isEnabled(BloodStainedBlockConfig.class) && !(event.entity instanceof VengeanceSpirit)) {
            int x = MathHelper.func_76128_c((double)event.entity.field_70165_t);
            int y = MathHelper.func_76128_c((double)(event.entity.field_70163_u - event.entity.func_70033_W() - 1.0));
            int z = MathHelper.func_76128_c((double)event.entity.field_70161_v);
            Block block = event.entity.field_70170_p.func_147439_a(x, y, z);
            if (BloodStainedBlock.getInstance().canSetInnerBlock(block, (IBlockAccess)event.entity.field_70170_p, x, y, z) || block == BloodStainedBlock.getInstance()) {
                if (!event.entity.field_70170_p.field_72995_K) {
                    BloodStainedBlock.getInstance().stainBlock(event.entity.field_70170_p, new Location(x, y, z), (int)((float)BloodStainedBlockConfig.bloodMBPerHP * event.entityLiving.func_110138_aP()));
                } else {
                    Random random = new Random();
                    EntityBloodSplashFX.spawnParticles(event.entity.field_70170_p, x, y + 1, z, (int)event.entityLiving.func_110138_aP() + random.nextInt(15), 5 + random.nextInt(5));
                }
            }
        }
    }

    private void vengeanceEvent(LivingDeathEvent event) {
        if (event.entityLiving != null) {
            World world = event.entityLiving.field_70170_p;
            double x = event.entityLiving.field_70165_t;
            double y = event.entityLiving.field_70163_u;
            double z = event.entityLiving.field_70161_v;
            boolean directToPlayer = this.shouldDirectSpiritToPlayer(event);
            if (!world.field_72995_K && !(world instanceof FakeWorld) && world.field_73013_u != EnumDifficulty.PEACEFUL && Configs.isEnabled(VengeanceSpiritConfig.class) && VengeanceSpirit.canSustain(event.entityLiving) && (directToPlayer || VengeanceSpirit.canSpawnNew(world, x, y, z))) {
                VengeanceSpirit spirit = new VengeanceSpirit(world);
                spirit.setInnerEntity(event.entityLiving);
                spirit.func_82149_j((Entity)event.entityLiving);
                spirit.func_110161_a(null);
                world.func_72838_d((Entity)spirit);
                if (directToPlayer) {
                    EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
                    spirit.setBuildupDuration(60);
                    spirit.setGlobalVengeance(true);
                    spirit.func_70784_b((Entity)player);
                }
            }
        }
    }

    private boolean shouldDirectSpiritToPlayer(LivingDeathEvent event) {
        if (event.source.func_76364_f() instanceof EntityPlayer && Configs.isEnabled(VengeanceRingConfig.class)) {
            EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
            PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
            while (it.hasNext()) {
                ItemStack itemStack = it.next();
                if (itemStack == null || itemStack.func_77973_b() != VengeanceRing.getInstance()) continue;
                return true;
            }
        }
        return false;
    }

    private void dropHumanoidFleshEvent(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityPlayerMP && Configs.isEnabled(WerewolfFleshConfig.class) && !event.entityLiving.field_70170_p.field_72995_K && event.entityLiving.field_70170_p.field_73012_v.nextInt(WerewolfFleshConfig.humanoidFleshDropChance) == 0) {
            EntityPlayerMP player = (EntityPlayerMP)event.entityLiving;
            ItemStack itemStack = new ItemStack((Item)WerewolfFlesh.getInstance(), 1, 1);
            NBTTagCompound tag = itemStack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                itemStack.func_77982_d(tag);
            }
            NBTUtil.func_152460_a((NBTTagCompound)tag, (GameProfile)player.func_146103_bH());
            double x = player.field_70165_t;
            double y = player.field_70163_u;
            double z = player.field_70161_v;
            EntityItem entity = new EntityItem(player.field_70170_p, x, y, z, itemStack);
            player.field_70170_p.func_72838_d((Entity)entity);
        }
    }

    private void palingDeath(LivingDeathEvent event) {
        if (event.source == ExtendedDamageSource.paling && Configs.isEnabled(SpiritPortalConfig.class)) {
            int x = (int)(event.entityLiving.field_70165_t - (double)(event.entityLiving.field_70130_N / 2.0f));
            int y = (int)(event.entityLiving.field_70163_u - (double)(event.entityLiving.field_70131_O / 2.0f) + 1.0);
            int z = (int)(event.entityLiving.field_70161_v - (double)(event.entityLiving.field_70130_N / 2.0f));
            SpiritPortal.tryPlacePortal(event.entityLiving.field_70170_p, x, y, z);
        }
    }
}

