/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.infobook;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.GameData;
import evilcraft.Configs;
import evilcraft.Recipes;
import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.block.BloodInfuser;
import evilcraft.block.BloodInfuserConfig;
import evilcraft.block.EnvironmentalAccumulator;
import evilcraft.block.EnvironmentalAccumulatorConfig;
import evilcraft.core.helper.CraftingHelpers;
import evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;
import evilcraft.core.recipe.custom.ItemStackRecipeComponent;
import evilcraft.core.recipe.xml.ConfigRecipeConditionHandler;
import evilcraft.core.recipe.xml.IRecipeConditionHandler;
import evilcraft.core.recipe.xml.XmlRecipeLoader;
import evilcraft.core.weather.WeatherType;
import evilcraft.infobook.InfoSection;
import evilcraft.infobook.InfoSectionTagIndex;
import evilcraft.infobook.pageelement.BloodInfuserRecipeAppendix;
import evilcraft.infobook.pageelement.CraftingRecipeAppendix;
import evilcraft.infobook.pageelement.EnvironmentalAccumulatorRecipeAppendix;
import evilcraft.infobook.pageelement.FurnaceRecipeAppendix;
import evilcraft.infobook.pageelement.ImageAppendix;
import evilcraft.infobook.pageelement.SectionAppendix;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InfoBookParser {
    private static final String BASE_PATH = "/assets/evilcraft/info/";
    private static final String BOOK = "book.xml";
    private static final Map<String, IInfoSectionFactory> SECTION_FACTORIES = Maps.newHashMap();
    private static final Map<String, IAppendixFactory> APPENDIX_FACTORIES;
    private static final Set<String> IGNORED_APPENDIX_FACTORIES;
    private static final Map<String, IAppendixItemFactory> APPENDIX_LIST_FACTORIES;
    public static Map<String, Pair<InfoSection, Integer>> configLinks;

    private static int getIndex(Element node) {
        int index = 0;
        if (!node.getAttribute("index").isEmpty()) {
            index = Integer.parseInt(node.getAttribute("index"));
        }
        return index;
    }

    private static ItemStack createStack(Element node) throws InvalidAppendixException {
        Item item;
        int meta = Short.MAX_VALUE;
        if (!node.getAttribute("meta").isEmpty()) {
            meta = Integer.parseInt(node.getAttribute("meta"));
        }
        if ((item = (Item)GameData.getItemRegistry().func_82594_a(node.getTextContent())) == null) {
            throw new InvalidAppendixException("Invalid item " + node.getTextContent());
        }
        return new ItemStack(item, 1, meta);
    }

    public static InfoSection initializeInfoBook() {
        try {
            InputStream is = InfoBookParser.class.getResourceAsStream("/assets/evilcraft/info/book.xml");
            StreamSource stream = new StreamSource(is);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(stream.getInputStream());
            InfoSection root = InfoBookParser.buildSection(null, 0, doc.getDocumentElement());
            root.registerSection(new InfoSectionTagIndex(root));
            return root;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new InfoBookException("Info Book XML is invalid.");
    }

    protected static InfoSection buildSection(InfoSection parent, int childIndex, Element sectionElement) {
        NodeList sections = sectionElement.getElementsByTagName("section");
        NodeList tags = sectionElement.getElementsByTagName("tag");
        NodeList paragraphs = sectionElement.getElementsByTagName("paragraph");
        NodeList appendixes = sectionElement.getElementsByTagName("appendix");
        NodeList appendixLists = sectionElement.getElementsByTagName("appendixList");
        ArrayList paragraphList = Lists.newArrayListWithCapacity((int)paragraphs.getLength());
        ArrayList appendixList = Lists.newArrayListWithCapacity((int)appendixes.getLength());
        ArrayList tagList = Lists.newArrayListWithCapacity((int)tags.getLength());
        InfoSection section = InfoBookParser.createSection(parent, childIndex, sectionElement.getAttribute("type"), sectionElement.getAttribute("name"), paragraphList, appendixList, tagList);
        if (sections.getLength() > 0) {
            int subChildIndex = 0;
            for (int i = 0; i < sections.getLength(); ++i) {
                InfoSection subsubsection;
                Element subsection = (Element)sections.item(i);
                if (subsection.getParentNode() != sectionElement || (subsubsection = InfoBookParser.buildSection(section, subChildIndex, subsection)) == null) continue;
                section.registerSection(subsubsection);
                ++subChildIndex;
            }
        } else {
            int j;
            for (j = 0; j < tags.getLength(); ++j) {
                IRecipeConditionHandler conditionHandler;
                Element tag = (Element)tags.item(j);
                String tagString = tag.getTextContent();
                String type = "config";
                if (tag.hasAttribute("type")) {
                    type = tag.getAttribute("type");
                }
                if (!(conditionHandler = XmlRecipeLoader.RECIPE_CONDITION_HANDLERS.get(type)).isSatisfied(tag.getTextContent())) {
                    return null;
                }
                if (!(conditionHandler instanceof ConfigRecipeConditionHandler)) continue;
                tagList.add(tagString);
            }
            for (j = 0; j < paragraphs.getLength(); ++j) {
                Element paragraph = (Element)paragraphs.item(j);
                paragraphList.add(paragraph.getTextContent());
            }
            for (j = 0; j < appendixes.getLength(); ++j) {
                try {
                    Element appendix = (Element)appendixes.item(j);
                    appendixList.add(InfoBookParser.createAppendix(appendix.getAttribute("type"), appendix));
                    continue;
                }
                catch (InvalidAppendixException appendix) {
                    // empty catch block
                }
            }
            for (j = 0; j < appendixLists.getLength(); ++j) {
                Element appendixListNode = (Element)appendixLists.item(j);
                String type = appendixListNode.getAttribute("type");
                Collection itemStacks = Recipes.taggedOutput.get((Object)appendixListNode.getTextContent());
                for (ItemStack itemStack : itemStacks) {
                    try {
                        appendixList.add(InfoBookParser.createAppendix(appendixListNode.getAttribute("type"), itemStack));
                    }
                    catch (InvalidAppendixException invalidAppendixException) {}
                }
            }
        }
        return section;
    }

    protected static InfoSection createSection(InfoSection parent, int childIndex, String type, String unlocalizedName, ArrayList<String> paragraphs, List<SectionAppendix> appendixes, ArrayList<String> tagList) {
        IInfoSectionFactory factory;
        if (type == null) {
            type = "";
        }
        if ((factory = SECTION_FACTORIES.get(type)) == null) {
            throw new InfoBookException("No section of type '" + type + "' was found.");
        }
        return factory.create(parent, childIndex, unlocalizedName, paragraphs, appendixes, tagList);
    }

    protected static SectionAppendix createAppendix(String type, Element node) throws InvalidAppendixException {
        IAppendixFactory factory;
        if (type == null) {
            type = "";
        }
        if ((factory = APPENDIX_FACTORIES.get(type)) == null) {
            if (IGNORED_APPENDIX_FACTORIES.contains(type)) {
                throw new InvalidAppendixException("Ignore appendix of type '" + type + "'.");
            }
            throw new InfoBookException("No appendix of type '" + type + "' was found.");
        }
        return factory.create(node);
    }

    protected static SectionAppendix createAppendix(String type, ItemStack itemStack) throws InvalidAppendixException {
        IAppendixItemFactory factory;
        if (type == null) {
            type = "";
        }
        if ((factory = APPENDIX_LIST_FACTORIES.get(type)) == null) {
            throw new InfoBookException("No appendix list of type '" + type + "' was found.");
        }
        return factory.create(itemStack);
    }

    static {
        SECTION_FACTORIES.put("", new IInfoSectionFactory(){

            @Override
            public InfoSection create(InfoSection parent, int childIndex, String unlocalizedName, ArrayList<String> paragraphs, List<SectionAppendix> appendixes, ArrayList<String> tagList) {
                return new InfoSection(parent, childIndex, unlocalizedName, paragraphs, appendixes, tagList);
            }
        });
        APPENDIX_FACTORIES = Maps.newHashMap();
        IGNORED_APPENDIX_FACTORIES = Sets.newHashSet();
        APPENDIX_FACTORIES.put("image", new IAppendixFactory(){

            @Override
            public SectionAppendix create(Element node) throws InvalidAppendixException {
                return new ImageAppendix(new ResourceLocation(node.getTextContent()), Integer.parseInt(node.getAttribute("width")), Integer.parseInt(node.getAttribute("height")));
            }
        });
        APPENDIX_FACTORIES.put("craftingRecipe", new IAppendixFactory(){

            @Override
            public SectionAppendix create(Element node) throws InvalidAppendixException {
                return new CraftingRecipeAppendix(CraftingHelpers.findCraftingRecipe(InfoBookParser.createStack(node), InfoBookParser.getIndex(node)));
            }
        });
        if (Configs.isEnabled(BloodInfuserConfig.class)) {
            APPENDIX_FACTORIES.put("bloodInfuserRecipe", new IAppendixFactory(){

                @Override
                public SectionAppendix create(Element node) throws InvalidAppendixException {
                    ItemStack itemStack = InfoBookParser.createStack(node);
                    List<IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties>> recipes = BloodInfuser.getInstance().getRecipeRegistry().findRecipesByOutput(new ItemStackRecipeComponent(itemStack));
                    int index = InfoBookParser.getIndex(node);
                    if (index >= recipes.size()) {
                        throw new InvalidAppendixException("Could not find Blood Infuser recipe for " + itemStack.func_77973_b().func_77658_a() + "with index " + index);
                    }
                    return new BloodInfuserRecipeAppendix(recipes.get(index));
                }
            });
        } else {
            IGNORED_APPENDIX_FACTORIES.add("bloodInfuserRecipe");
        }
        APPENDIX_FACTORIES.put("furnaceRecipe", new IAppendixFactory(){

            @Override
            public SectionAppendix create(Element node) throws InvalidAppendixException {
                return new FurnaceRecipeAppendix(CraftingHelpers.findFurnaceRecipe(InfoBookParser.createStack(node), InfoBookParser.getIndex(node)));
            }
        });
        if (Configs.isEnabled(EnvironmentalAccumulatorConfig.class)) {
            APPENDIX_FACTORIES.put("envirAccRecipe", new IAppendixFactory(){

                @Override
                public SectionAppendix create(Element node) throws InvalidAppendixException {
                    ItemStack itemStack = InfoBookParser.createStack(node);
                    List<IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties>> recipes = EnvironmentalAccumulator.getInstance().getRecipeRegistry().findRecipesByOutput(new EnvironmentalAccumulatorRecipeComponent(itemStack, WeatherType.ANY));
                    int index = InfoBookParser.getIndex(node);
                    if (index >= recipes.size()) {
                        throw new InvalidAppendixException("Could not find Environmental Accumulator recipe for " + itemStack.func_77973_b().func_77658_a() + "with index " + index);
                    }
                    return new EnvironmentalAccumulatorRecipeAppendix(recipes.get(index));
                }
            });
        } else {
            IGNORED_APPENDIX_FACTORIES.add("envirAccRecipe");
        }
        APPENDIX_LIST_FACTORIES = Maps.newHashMap();
        APPENDIX_LIST_FACTORIES.put("craftingRecipe", new IAppendixItemFactory(){

            @Override
            public SectionAppendix create(ItemStack itemStack) throws InvalidAppendixException {
                return new CraftingRecipeAppendix(CraftingHelpers.findCraftingRecipe(itemStack, 0));
            }
        });
        APPENDIX_LIST_FACTORIES.put("bloodInfuserRecipe", new IAppendixItemFactory(){

            @Override
            public SectionAppendix create(ItemStack itemStack) throws InvalidAppendixException {
                List<IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties>> recipes = BloodInfuser.getInstance().getRecipeRegistry().findRecipesByOutput(new ItemStackRecipeComponent(itemStack));
                return new BloodInfuserRecipeAppendix(recipes.get(0));
            }
        });
        APPENDIX_LIST_FACTORIES.put("furnaceRecipe", new IAppendixItemFactory(){

            @Override
            public SectionAppendix create(ItemStack itemStack) throws InvalidAppendixException {
                return new FurnaceRecipeAppendix(CraftingHelpers.findFurnaceRecipe(itemStack, 0));
            }
        });
        APPENDIX_LIST_FACTORIES.put("envirAccRecipe", new IAppendixItemFactory(){

            @Override
            public SectionAppendix create(ItemStack itemStack) throws InvalidAppendixException {
                List<IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties>> recipes = EnvironmentalAccumulator.getInstance().getRecipeRegistry().findRecipesByOutput(new EnvironmentalAccumulatorRecipeComponent(itemStack, WeatherType.ANY));
                return new EnvironmentalAccumulatorRecipeAppendix(recipes.get(0));
            }
        });
    }

    public static class InvalidAppendixException
    extends Exception {
        public InvalidAppendixException(String message) {
            super(message);
        }
    }

    public static class InfoBookException
    extends RuntimeException {
        public InfoBookException(String message) {
            super(message);
        }
    }

    protected static interface IAppendixItemFactory {
        public SectionAppendix create(ItemStack var1) throws InvalidAppendixException;
    }

    protected static interface IAppendixFactory {
        public SectionAppendix create(Element var1) throws InvalidAppendixException;
    }

    protected static interface IInfoSectionFactory {
        public InfoSection create(InfoSection var1, int var2, String var3, ArrayList<String> var4, List<SectionAppendix> var5, ArrayList<String> var6);
    }
}

