/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.infobook;

import com.google.common.collect.Maps;
import evilcraft.core.config.ConfigHandler;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.infobook.InfoBookParser;
import evilcraft.infobook.InfoSection;
import evilcraft.infobook.pageelement.SectionAppendix;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import org.apache.commons.lang3.tuple.Pair;

public class InfoSectionTagIndex
extends InfoSection {
    public InfoSectionTagIndex(InfoSection parent) {
        super(parent, parent.getSubSections(), "infoBook.tagIndex", new ArrayList<String>(), new ArrayList<SectionAppendix>(), new ArrayList<String>());
        InfoBookParser.configLinks = Maps.newTreeMap((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return L10NHelpers.localize(o1).compareTo(L10NHelpers.localize(o2));
            }
        });
        this.addSoftLinks(InfoBookParser.configLinks, this.getParent());
    }

    @Override
    public void bakeSection(FontRenderer fontRenderer, int width, int maxLines, int lineHeight) {
        if (this.paragraphs.size() == 0) {
            this.addLinks(maxLines, lineHeight, InfoBookParser.configLinks);
        }
        super.bakeSection(fontRenderer, width, maxLines, lineHeight);
    }

    @Override
    protected boolean shouldAddIndex() {
        return false;
    }

    protected void addSoftLinks(Map<String, Pair<InfoSection, Integer>> softLinks, InfoSection section) {
        for (String tag : section.getTags()) {
            if (softLinks.containsKey(tag)) {
                throw new IllegalArgumentException("The tag " + tag + " occurs multiple times.");
            }
            ExtendedConfig config = ConfigHandler.getInstance().getDictionary().get(tag);
            if (config == null) continue;
            softLinks.put(config.getFullUnlocalizedName(), (Pair<InfoSection, Integer>)Pair.of((Object)section, (Object)0));
        }
        for (int i = 0; i < section.getSubSections(); ++i) {
            this.addSoftLinks(softLinks, section.getSubSection(i));
        }
    }
}

