/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.Configs;
import evilcraft.block.BloodStainedBlock;
import evilcraft.block.BloodStainedBlockConfig;
import evilcraft.client.particle.EntityBloodSplashFX;
import evilcraft.core.algorithm.Location;
import evilcraft.core.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.core.helper.ItemHelpers;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.fluid.Blood;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.ItemFluidContainer;

public class CreativeBloodDrop
extends ConfigurableDamageIndicatedItemFluidContainer {
    private static CreativeBloodDrop _instance = null;
    private static final int MB_FILL_PERTICK = 1000;

    public static void initInstance(ExtendedConfig<ItemConfig> eConfig) {
        if (_instance == null) {
            _instance = new CreativeBloodDrop(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static CreativeBloodDrop getInstance() {
        return _instance;
    }

    private CreativeBloodDrop(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, 1000, Blood.getInstance());
        this.setPlaceFluids(true);
    }

    public int getCapacity(ItemStack container) {
        return 1000;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        L10NHelpers.addStatusInfo(list, ItemHelpers.isActivated(itemStack), this.func_77658_a() + ".info.autoSupply");
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        CreativeBloodDrop.updateAutoFill(this, itemStack, world, entity);
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public static void updateAutoFill(ItemFluidContainer item, ItemStack itemStack, World world, Entity entity) {
        IFluidContainerItem fluidContainer;
        FluidStack heldFluid;
        EntityPlayer player;
        ItemStack held;
        FluidStack tickFluid;
        if (entity instanceof EntityPlayer && !world.field_72995_K && ItemHelpers.isActivated(itemStack) && (tickFluid = item.getFluid(itemStack)) != null && tickFluid.amount > 0 && (held = (player = (EntityPlayer)entity).func_71045_bC()) != null && held != itemStack && held.func_77973_b() instanceof IFluidContainerItem && !player.func_71039_bw() && ((heldFluid = (fluidContainer = (IFluidContainerItem)held.func_77973_b()).getFluid(held)) == null || heldFluid.isFluidEqual(tickFluid) && heldFluid.amount < fluidContainer.getCapacity(held))) {
            int filled = fluidContainer.fill(held, new FluidStack(tickFluid.getFluid(), 1000), true);
            item.drain(itemStack, filled, true);
        }
    }

    @Override
    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        return new FluidStack(this.getFluid(), maxDrain);
    }

    @Override
    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        return resource.amount;
    }

    public FluidStack getFluid(ItemStack itemStack) {
        return new FluidStack(this.getFluid(), 500);
    }

    public int getDisplayDamage(ItemStack itemStack) {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        itemList.add(new ItemStack((Item)this));
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block = world.func_147439_a(x, y, z);
        if (player.func_70093_af() && Configs.isEnabled(BloodStainedBlockConfig.class) && (BloodStainedBlock.getInstance().canSetInnerBlock(block, (IBlockAccess)world, x, y, z) || block == BloodStainedBlock.getInstance())) {
            BloodStainedBlock.getInstance().stainBlock(world, new Location(x, y, z), 1000);
            if (world.field_72995_K) {
                EntityBloodSplashFX.spawnParticles(world, x, y + 1, z, 5, 1 + world.field_73012_v.nextInt(2));
            }
            return false;
        }
        return super.onItemUseFirst(itemStack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!player.func_70093_af()) {
            return super.func_77659_a(itemStack, world, player);
        }
        MovingObjectPosition target = this.func_77621_a(world, player, false);
        if (!(target != null && target.field_72313_a != MovingObjectPosition.MovingObjectType.MISS || world.field_72995_K)) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return itemStack;
    }
}

