/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.client.gui.container.GuiExaltedCrafter;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.inventory.NBTSimpleInventoryItemHeld;
import evilcraft.core.item.ItemGui;
import evilcraft.entity.item.EntityItemEmpowerable;
import evilcraft.inventory.container.ContainerExaltedCrafter;
import evilcraft.item.IItemEmpowerable;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ExaltedCrafter
extends ItemGui
implements IItemEmpowerable {
    private static final String NBT_RETURNTOINNER = "returnToInner";
    private static ExaltedCrafter _instance = null;
    @SideOnly(value=Side.CLIENT)
    private IIcon woodenIcon;

    public static void initInstance(ExtendedConfig<ItemConfig> eConfig) {
        if (_instance == null) {
            _instance = new ExaltedCrafter(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static ExaltedCrafter getInstance() {
        return _instance;
    }

    private ExaltedCrafter(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.func_77625_d(1);
        if (MinecraftHelpers.isClientSide()) {
            this.setGUI(GuiExaltedCrafter.class);
        }
        this.setContainer(ContainerExaltedCrafter.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.woodenIcon = iconRegister.func_94245_a(this.func_111208_A() + "_wooden");
        super.func_94581_a(iconRegister);
    }

    public IIcon func_77617_a(int damage) {
        if ((damage & 1) == 1) {
            return this.woodenIcon;
        }
        return super.func_77617_a(damage);
    }

    public boolean hasEffect(ItemStack itemStack, int pass) {
        return this.isEmpowered(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemStack) {
        return this.isEmpowered(itemStack) ? EnumRarity.uncommon : super.func_77613_e(itemStack);
    }

    @Override
    public boolean isEmpowered(ItemStack itemStack) {
        return (itemStack.func_77960_j() >> 1 & 1) == 1;
    }

    @Override
    public ItemStack empower(ItemStack itemStack) {
        if (itemStack.func_77973_b() == this) {
            itemStack.func_77964_b(itemStack.func_77960_j() | 2);
        }
        return itemStack;
    }

    protected boolean isWooden(ItemStack itemStack) {
        return (itemStack.func_77960_j() & 1) == 1;
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77658_a() + (this.isWooden(itemStack) ? ".wood" : "");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        itemList.add(new ItemStack(item, 1, 0));
        itemList.add(new ItemStack(item, 1, 1));
        itemList.add(new ItemStack(item, 1, 2));
        itemList.add(new ItemStack(item, 1, 3));
    }

    public IInventory getSupplementaryInventory(EntityPlayer player, ItemStack itemStack, int itemIndex) {
        if (this.isWooden(itemStack)) {
            return new NBTSimpleInventoryItemHeld(player, itemIndex, 27, 64);
        }
        return player.func_71005_bN();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        if (this.isEmpowered(itemStack)) {
            list.add(EnumChatFormatting.RED + "Empowered");
        }
    }

    public boolean hasCustomEntity(ItemStack itemStack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemStack) {
        return new EntityItemEmpowerable(world, (EntityItem)location);
    }

    public void setReturnToInner(ItemStack itemStack, boolean returnToInner) {
        if (itemStack.func_77942_o()) {
            itemStack.func_77978_p().func_74757_a(NBT_RETURNTOINNER, returnToInner);
        }
    }

    public boolean isReturnToInner(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74767_n(NBT_RETURNTOINNER);
        }
        return false;
    }
}

