/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import evilcraft.core.helper.ItemHelpers;
import evilcraft.core.helper.L10NHelpers;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ItemPowerableHelpers {
    private static final String NBT_KEY_POWER = "power";

    public static int getPower(ItemStack itemStack) {
        return ItemHelpers.getNBTInt(itemStack, NBT_KEY_POWER);
    }

    public static void setPower(ItemStack itemStack, int power) {
        ItemHelpers.setNBTInt(itemStack, power, NBT_KEY_POWER);
    }

    public static boolean onPowerableItemItemRightClick(ItemStack itemStack, World world, EntityPlayer player, int powerLevels, boolean onSneak) {
        if (onSneak == player.func_70093_af()) {
            if (!world.field_72995_K) {
                int newPower = (ItemPowerableHelpers.getPower(itemStack) + 1) % powerLevels;
                ItemPowerableHelpers.setPower(itemStack, newPower);
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + L10NHelpers.localize("item.powerable.setPower", newPower)));
            }
            return true;
        }
        return false;
    }

    public static void addPreInformation(ItemStack itemStack, List<String> lines) {
        L10NHelpers.addOptionalInfo(lines, "item.powerable");
    }

    public static void addPostInformation(ItemStack itemStack, List<String> lines) {
        lines.add(EnumChatFormatting.BOLD + L10NHelpers.localize("item.powerable.info.power", ItemPowerableHelpers.getPower(itemStack)));
    }
}

