/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import com.google.common.collect.Multimap;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.client.particle.EntityDistortFX;
import evilcraft.client.particle.EntityPlayerTargettedBlurFX;
import evilcraft.client.particle.ExtendedEntityExplodeFX;
import evilcraft.core.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.fluid.Blood;
import evilcraft.item.ItemPowerableHelpers;
import java.util.List;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public abstract class Mace
extends ConfigurableDamageIndicatedItemFluidContainer {
    private final int hitUsage;
    private final int maximumCharge;
    private final int powerLevels;
    private final float meleeDamage;

    public Mace(ExtendedConfig<ItemConfig> eConfig, int containerSize, int hitUsage, int maximumCharge, int powerLevels, float meleeDamage) {
        super(eConfig, containerSize, Blood.getInstance());
        this.hitUsage = hitUsage;
        this.maximumCharge = maximumCharge;
        this.powerLevels = powerLevels;
        this.meleeDamage = meleeDamage;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    protected boolean isUsable(ItemStack itemStack, EntityPlayer player) {
        return this.canConsume(1, itemStack, player);
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase attacked, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer && this.isUsable(itemStack, (EntityPlayer)attacker)) {
            this.drain(itemStack, this.hitUsage, true);
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack itemStack, EntityPlayer player, Entity entity) {
        return !this.isUsable(itemStack, player);
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.bow;
    }

    public int func_77626_a(ItemStack itemStack) {
        return this.maximumCharge * (this.powerLevels - this.getPower(itemStack));
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (ItemPowerableHelpers.onPowerableItemItemRightClick(itemStack, world, player, this.powerLevels, true)) {
            return itemStack;
        }
        if (this.isUsable(itemStack, player)) {
            player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        } else if (world.field_72995_K) {
            this.animateOutOfEnergy(world, player);
        }
        return itemStack;
    }

    public void onUsingTick(ItemStack itemStack, EntityPlayer player, int duration) {
        World world = player.field_70170_p;
        if (world.field_72995_K && duration % 2 == 0) {
            this.showUsingItemTick(world, itemStack, player, duration);
        }
        super.onUsingTick(itemStack, player, duration);
    }

    @SideOnly(value=Side.CLIENT)
    protected void showUsingItemTick(World world, ItemStack itemStack, EntityPlayer player, int duration) {
        int itemUsedCount = this.func_77626_a(itemStack) - duration;
        double area = this.getArea(itemUsedCount);
        int points = (int)Math.pow(area, 0.55) * 2 + 1;
        int particleChance = 5 * (this.powerLevels - this.getPower(itemStack));
        for (double point = (double)(-points); point <= (double)points; point += 1.0) {
            for (double pointHeight = (double)(-points); pointHeight <= (double)points; pointHeight += 0.5) {
                if (field_77697_d.nextInt(particleChance) != 0) continue;
                double u = Math.PI * (point / (double)points);
                double v = Math.PI * -2 * (pointHeight / (double)points);
                double xOffset = Math.cos(u) * Math.sin(v) * area;
                double yOffset = Math.sin(u) * area;
                double zOffset = Math.cos(v) * area;
                double xCoord = player.field_70165_t;
                double yCoord = player.field_70163_u - 0.5;
                double zCoord = player.field_70161_v;
                double particleX = xCoord + xOffset - (double)world.field_73012_v.nextFloat() * area / 4.0 - 0.5;
                double particleY = yCoord + yOffset - (double)world.field_73012_v.nextFloat() * area / 4.0 - 0.5;
                double particleZ = zCoord + zOffset - (double)world.field_73012_v.nextFloat() * area / 4.0 - 0.5;
                float particleMotionX = (float)(xOffset * 10.0);
                float particleMotionY = (float)(yOffset * 10.0);
                float particleMotionZ = (float)(zOffset * 10.0);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntityDistortFX(world, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ, (float)area * 3.0f));
                if (world.field_73012_v.nextInt(10) != 0) continue;
                int spread = 10;
                float scale2 = 0.3f - world.field_73012_v.nextFloat() * 0.2f;
                float r = 1.0f * world.field_73012_v.nextFloat();
                float g = 0.2f + 0.01f * world.field_73012_v.nextFloat();
                float b = 0.1f + 0.5f * world.field_73012_v.nextFloat();
                float ageMultiplier2 = 20.0f;
                double motionX = (double)spread - world.field_73012_v.nextDouble() * 2.0 * (double)spread;
                double motionY = (double)spread - world.field_73012_v.nextDouble() * 2.0 * (double)spread;
                double motionZ = (double)spread - world.field_73012_v.nextDouble() * 2.0 * (double)spread;
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntityPlayerTargettedBlurFX(world, scale2, motionX, motionY, motionZ, r, g, b, ageMultiplier2, player));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void showUsedItemTick(World world, EntityPlayer player, int power) {
        int particles = (power + 1) * (power + 1) * (power + 1) * 10;
        for (int i = 0; i < particles; ++i) {
            double x = player.field_70165_t - 0.5 + world.field_73012_v.nextDouble();
            double y = player.field_70163_u - 1.0 + world.field_73012_v.nextDouble();
            double z = player.field_70161_v - 0.5 + world.field_73012_v.nextDouble();
            double particleMotionX = (-1.0 + world.field_73012_v.nextDouble() * 2.0) * (double)(power + 1) / 2.0;
            double particleMotionY = (-1.0 + world.field_73012_v.nextDouble() * 2.0) * (double)(power + 1) / 2.0;
            double particleMotionZ = (-1.0 + world.field_73012_v.nextDouble() * 2.0) * (double)(power + 1) / 2.0;
            float r = 1.0f * world.field_73012_v.nextFloat();
            float g = 0.2f + 0.01f * world.field_73012_v.nextFloat();
            float b = 0.1f + 0.5f * world.field_73012_v.nextFloat();
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new ExtendedEntityExplodeFX(world, x, y, z, particleMotionX, particleMotionY, particleMotionZ, r, g, b, 0.3f));
        }
    }

    protected double getArea(int itemUsedCount) {
        return (double)(itemUsedCount / 5) + 2.0;
    }

    public void func_77615_a(ItemStack itemStack, World world, EntityPlayer player, int itemInUseCount) {
        int itemUsedCount = this.func_77626_a(itemStack) - itemInUseCount;
        int toDrain = itemUsedCount * this.getCapacity(itemStack) * (this.getPower(itemStack) + 1) / (this.func_77626_a(itemStack) * this.powerLevels);
        FluidStack consumed = this.consume(toDrain, itemStack, player);
        int consumedAmount = consumed == null ? 0 : consumed.amount;
        itemUsedCount = consumedAmount * this.func_77626_a(itemStack) / this.getCapacity(itemStack);
        if (consumedAmount > 0) {
            this.use(world, player, itemUsedCount, this.getPower(itemStack));
            if (world.field_72995_K) {
                this.showUsedItemTick(world, player, this.getPower(itemStack));
            }
        } else if (world.field_72995_K) {
            this.animateOutOfEnergy(world, player);
        }
    }

    protected abstract void use(World var1, EntityPlayer var2, int var3, int var4);

    @SideOnly(value=Side.CLIENT)
    protected void animateOutOfEnergy(World world, EntityPlayer player) {
        double xCoord = player.field_70165_t;
        double yCoord = player.field_70163_u;
        double zCoord = player.field_70161_v;
        double particleX = xCoord;
        double particleY = yCoord;
        double particleZ = zCoord;
        float particleMotionX = world.field_73012_v.nextFloat() * 0.2f - 0.1f;
        float particleMotionY = 0.2f;
        float particleMotionZ = world.field_73012_v.nextFloat() * 0.2f - 0.1f;
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntitySmokeFX(world, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ));
        world.func_72956_a((Entity)player, "note.bd", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
    }

    public int func_77619_b() {
        return 15;
    }

    public Multimap getAttributeModifiers(ItemStack itemStack) {
        Multimap multimap = super.getAttributeModifiers(itemStack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.meleeDamage, 0));
        return multimap;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        ItemPowerableHelpers.addPreInformation(itemStack, list);
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        ItemPowerableHelpers.addPostInformation(itemStack, list);
    }

    public int getPower(ItemStack itemStack) {
        return ItemPowerableHelpers.getPower(itemStack);
    }
}

