/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.EvilCraft;
import evilcraft.client.gui.GuiHandler;
import evilcraft.client.gui.container.GuiPrimedPendant;
import evilcraft.core.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.core.helper.Helpers;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.inventory.IGuiContainerProvider;
import evilcraft.core.inventory.NBTSimpleInventoryItemHeld;
import evilcraft.core.inventory.NBTSimpleInventoryItemStack;
import evilcraft.fluid.Blood;
import evilcraft.inventory.container.ContainerPrimedPendant;
import evilcraft.item.PrimedPendantConfig;
import evilcraft.modcompat.baubles.BaublesModCompat;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles", striprefs=true)
public class PrimedPendant
extends ConfigurableDamageIndicatedItemFluidContainer
implements IBauble,
IGuiContainerProvider {
    private static final int TICK_MODULUS = 10;
    private static PrimedPendant _instance = null;
    private int guiID;
    private Class<? extends Container> container;
    @SideOnly(value=Side.CLIENT)
    private Class<? extends GuiScreen> gui;

    public static void initInstance(ExtendedConfig<ItemConfig> eConfig) {
        if (_instance == null) {
            _instance = new PrimedPendant(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static PrimedPendant getInstance() {
        return _instance;
    }

    private PrimedPendant(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, PrimedPendantConfig.capacity, Blood.getInstance());
        this.func_77625_d(1);
        this.guiID = Helpers.getNewId(Helpers.IDType.GUI);
        if (MinecraftHelpers.isClientSide()) {
            this.setGUI(GuiPrimedPendant.class);
        }
        this.setContainer(ContainerPrimedPendant.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        ItemStack potionStack = this.getPotionStack(itemStack);
        if (potionStack != null) {
            List potionEffects = Items.field_151068_bn.func_77832_l(potionStack);
            for (PotionEffect potionEffect : potionEffects) {
                Double multiplier = PrimedPendantConfig._instance.getMultiplier(potionEffect.func_76456_a());
                String striked = multiplier != null && multiplier < 0.0 ? "\u00a7m" : "";
                list.add(L10NHelpers.localize(super.func_77667_c(itemStack) + ".potion", striked + L10NHelpers.localize(potionEffect.func_76453_d()), StatCollector.func_74838_a((String)("enchantment.level." + (potionEffect.func_76458_c() + 1)))));
            }
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer && world.func_72820_D() % 10L == 0L) {
            EntityPlayer player = (EntityPlayer)entity;
            List<PotionEffect> potionEffects = this.getPotionEffects(itemStack);
            for (PotionEffect potionEffect : potionEffects) {
                int toDrain = PrimedPendantConfig.usage * (potionEffect.func_76458_c() + 1);
                Double multiplier = PrimedPendantConfig._instance.getMultiplier(potionEffect.func_76456_a());
                if (multiplier != null) {
                    toDrain = (int)((double)toDrain * multiplier);
                }
                if (multiplier != null && !(multiplier >= 0.0) || !this.canConsume(toDrain, itemStack, player)) continue;
                player.func_70690_d(new PotionEffect(potionEffect.func_76456_a(), 270, potionEffect.func_76458_c(), !potionEffect.getCurativeItems().isEmpty()));
                this.consume(toDrain, itemStack, player);
            }
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    private List<PotionEffect> getPotionEffects(ItemStack itemStack) {
        List potionEffects = null;
        ItemStack potionStack = this.getPotionStack(itemStack);
        if (potionStack != null) {
            potionEffects = Items.field_151068_bn.func_77832_l(potionStack);
        }
        return potionEffects == null ? Collections.emptyList() : potionEffects;
    }

    public boolean hasPotionStack(ItemStack itemStack) {
        return this.getPotionStack(itemStack) != null;
    }

    public ItemStack getPotionStack(ItemStack itemStack) {
        IInventory inventory = this.getSupplementaryInventory(itemStack);
        return inventory.func_70301_a(0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack itemStack, int pass) {
        return this.hasPotionStack(itemStack);
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemStack, EntityLivingBase entity) {
        return BaublesModCompat.canUse();
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemStack, EntityLivingBase entity) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.AMULET;
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemStack, EntityLivingBase entity) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemStack, EntityLivingBase entity) {
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack itemStack, EntityLivingBase entity) {
        if (BaublesModCompat.canUse()) {
            this.func_77663_a(itemStack, entity.field_70170_p, (Entity)entity, 0, false);
        }
    }

    public IInventory getSupplementaryInventory(EntityPlayer player, ItemStack itemStack, int itemIndex) {
        return new NBTSimpleInventoryItemHeld(player, itemIndex, 1, 64);
    }

    public IInventory getSupplementaryInventory(ItemStack itemStack) {
        return new NBTSimpleInventoryItemStack(itemStack, 1, 64);
    }

    @Override
    public int getGuiID() {
        return this.guiID;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setGUI(Class<? extends GuiScreen> gui) {
        this.gui = gui;
    }

    @Override
    public void setContainer(Class<? extends Container> container) {
        this.container = container;
    }

    @Override
    public Class<? extends Container> getContainer() {
        return this.container;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiScreen> getGUI() {
        return this.gui;
    }

    public boolean onDroppedByPlayer(ItemStack itemstack, EntityPlayer player) {
        if (itemstack != null && player instanceof EntityPlayerMP && player.field_71070_bA != null && player.field_71070_bA.getClass() == this.getContainer()) {
            ((EntityPlayerMP)player).func_71053_j();
        }
        return super.onDroppedByPlayer(itemstack, player);
    }

    @Override
    public String getGuiTexture() {
        return this.getGuiTexture("");
    }

    @Override
    public String getGuiTexture(String suffix) {
        return "textures/gui/" + this.eConfig.getNamedId() + "_gui" + suffix + ".png";
    }

    public void openGuiForItemIndex(World world, EntityPlayer player, int itemIndex) {
        GuiHandler.setTemporaryItemIndex(itemIndex);
        if (!world.field_72995_K || this.isClientSideOnlyGui()) {
            player.openGui((Object)EvilCraft._instance, this.getGuiID(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    protected boolean isClientSideOnlyGui() {
        return false;
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        this.openGuiForItemIndex(world, player, player.field_71071_by.field_70461_c);
        return itemStack;
    }
}

