/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import com.google.common.collect.Maps;
import evilcraft.EvilCraft;
import evilcraft.core.config.ConfigurableProperty;
import evilcraft.core.config.ConfigurableTypeCategory;
import evilcraft.core.config.IChangedCallback;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.item.PrimedPendant;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import org.apache.logging.log4j.Level;

public class PrimedPendantConfig
extends ItemConfig {
    private static final String DELIMITER = ":";
    public static PrimedPendantConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="The capacity of the pendant.", requiresMcRestart=true)
    public static int capacity;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="The amount of Blood to drain after one effect application.", isCommandable=true)
    public static int usage;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="Usage multipliers. Potion ids are first, followed by floating numbers. A number smaller than one blacklists that potion.", changedCallback=PotionMultipliersChanged.class)
    public static String[] potionMultipliers;
    private Map<Integer, Double> multipliers = Maps.newHashMap();

    public PrimedPendantConfig() {
        super(true, "primedPendant", (String)null, (Class<? extends Item>)PrimedPendant.class);
    }

    public void registerFromConfig(String[] config) {
        this.multipliers.clear();
        for (String line : config) {
            String[] split = line.split(DELIMITER);
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid line '" + line + "' found for " + "a Primed Pendant potion multiplier config.");
            }
            try {
                int potionId = Integer.parseInt(split[0]);
                if (potionId >= Potion.field_76425_a.length || Potion.field_76425_a[potionId] == null) {
                    EvilCraft.log("Invalid line '" + line + "' found for " + "a Primed Pendant potion multiplier config: " + split[0] + " does not refer to an existing potion; skipping.");
                }
                Potion potion = Potion.field_76425_a[potionId];
                double multiplier = 1.0;
                try {
                    multiplier = Double.parseDouble(split[1]);
                }
                catch (NumberFormatException e) {
                    EvilCraft.log("Invalid ratio '" + split[1] + "' in " + "a Primed Pendant potion multiplier config, using 1.0.", Level.ERROR);
                }
                this.multipliers.put(potion.func_76396_c(), multiplier);
            }
            catch (NumberFormatException e) {
                EvilCraft.log("Invalid line '" + line + "' found for " + "a Primed Pendant potion multiplier config: " + split[0] + " is not a number; skipping.");
            }
        }
    }

    public Double getMultiplier(int potionId) {
        return this.multipliers.get(potionId);
    }

    static {
        capacity = 5000;
        usage = 10;
        potionMultipliers = new String[]{Potion.field_76432_h.func_76396_c() + DELIMITER + "-1", Potion.field_76428_l.func_76396_c() + DELIMITER + "10"};
    }

    public static class PotionMultipliersChanged
    implements IChangedCallback {
        private static boolean calledOnce = false;

        @Override
        public void onChanged(Object value) {
            if (calledOnce) {
                _instance.registerFromConfig((String[])value);
            }
            calledOnce = true;
        }

        @Override
        public void onRegisteredPostInit(Object value) {
            this.onChanged(value);
        }
    }
}

