/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.EvilCraft;
import evilcraft.core.config.configurable.ConfigurableItem;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.core.helper.WorldHelpers;
import evilcraft.core.helper.obfuscation.ObfuscationHelpers;
import evilcraft.entity.effect.EntityAntiVengeanceBeam;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class VengeanceFocus
extends ConfigurableItem {
    private static final int TICK_MODULUS = 3;
    private static VengeanceFocus _instance = null;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public static void initInstance(ExtendedConfig<ItemConfig> eConfig) {
        if (_instance == null) {
            _instance = new VengeanceFocus(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static VengeanceFocus getInstance() {
        return _instance;
    }

    private VengeanceFocus(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a(this.func_111208_A());
        this.iconArray = new IIcon[4];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = par1IconRegister.func_94245_a(this.func_111208_A() + "_" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (this.getItemInUseDuration(player) == this.func_77626_a(usingItem)) {
            return this.getIcon(stack, renderPass);
        }
        return this.iconArray[Math.min(this.iconArray.length - 1, player.func_71057_bx() / 3)];
    }

    private int getItemInUseDuration(EntityPlayer player) {
        return player.func_71039_bw() ? ObfuscationHelpers.getItemInUse(player).func_77988_m() - ObfuscationHelpers.getItemInUseCount(player) : 0;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (this.getItemInUseDuration(player) > 0) {
            player.func_71041_bz();
        } else {
            player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        }
        return itemStack;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.bow;
    }

    public int func_77626_a(ItemStack itemStack) {
        return Integer.MAX_VALUE;
    }

    public void func_77615_a(ItemStack itemStack, World world, EntityPlayer player, int duration) {
        if (player.field_70170_p.field_72995_K && this.getItemInUseDuration(player) > 6) {
            EvilCraft.proxy.playSound(player.field_70165_t, player.field_70163_u, player.field_70161_v, "vengeanceBeamStop", 0.6f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f, 1.0f);
        }
    }

    public void onUsingTick(ItemStack itemStack, EntityPlayer player, int duration) {
        if (this.getItemInUseDuration(player) > 6) {
            if (WorldHelpers.efficientTick(player.field_70170_p, 3, player.func_145782_y())) {
                EntityAntiVengeanceBeam beam = new EntityAntiVengeanceBeam(player.field_70170_p, (EntityLivingBase)player);
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_72838_d((Entity)beam);
                }
            }
        } else if (this.getItemInUseDuration(player) == 3 && player.field_70170_p.field_72995_K) {
            EvilCraft.proxy.playSound(player.field_70165_t, player.field_70163_u, player.field_70161_v, "vengeanceBeamStart", 0.6f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f, 1.0f);
        }
    }
}

