/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.config.configurable.ConfigurableItem;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.core.helper.ItemHelpers;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.core.helper.WorldHelpers;
import evilcraft.entity.monster.VengeanceSpirit;
import evilcraft.entity.monster.VengeanceSpiritConfig;
import evilcraft.item.VengeanceRingConfig;
import evilcraft.modcompat.baubles.BaublesModCompat;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles", striprefs=true)
public class VengeanceRing
extends ConfigurableItem
implements IBauble {
    private static final int BONUS_TICK_MODULUS = 5;
    private static final int BONUS_POTION_DURATION = 60;
    private static final int[][] RING_POWERS = new int[][]{{Potion.field_76430_j.field_76415_H, 60, 2}, {Potion.field_76441_p.field_76415_H, 60, 1}, {Potion.field_76424_c.field_76415_H, 60, 1}, {Potion.field_76422_e.field_76415_H, 60, 1}};
    private static VengeanceRing _instance = null;

    public static void initInstance(ExtendedConfig<ItemConfig> eConfig) {
        if (_instance == null) {
            _instance = new VengeanceRing(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static VengeanceRing getInstance() {
        return _instance;
    }

    private VengeanceRing(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemHelpers.toggleActivation(itemStack);
            }
            return itemStack;
        }
        return super.func_77659_a(itemStack, world, player);
    }

    @Optional.Method(modid="Baubles")
    private void equipBauble(ItemStack itemStack, EntityPlayer player) {
        IInventory inventory = BaublesApi.getBaubles((EntityPlayer)player);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) != null || !inventory.func_94041_b(i, itemStack)) continue;
            inventory.func_70299_a(i, itemStack.func_77946_l());
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
            this.onEquipped(itemStack, (EntityLivingBase)player);
            break;
        }
    }

    public boolean hasEffect(ItemStack itemStack, int pass) {
        return ItemHelpers.isActivated(itemStack);
    }

    public static void toggleVengeanceArea(World world, Entity entity, int area, boolean enableVengeance, boolean spawnRandom, boolean forceGlobal) {
        if (world.field_73013_u != EnumDifficulty.PEACEFUL) {
            VengeanceSpirit spirit;
            double x = entity.field_70165_t;
            double y = entity.field_70163_u;
            double z = entity.field_70161_v;
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b((double)area, (double)area, (double)area);
            List spirits = world.func_94576_a(entity, box, new IEntitySelector(){

                public boolean func_82704_a(Entity entity) {
                    return entity instanceof VengeanceSpirit;
                }
            });
            for (VengeanceSpirit spirit2 : spirits) {
                spirit2.setEnabledVengeance((EntityPlayer)entity, enableVengeance);
                if (enableVengeance) {
                    spirit2.func_70784_b(entity);
                    continue;
                }
                if (spirit2.func_70777_m() != entity) continue;
                spirit2.func_70784_b(null);
            }
            if (spirits.size() == 0 && enableVengeance && (spirit = VengeanceSpirit.spawnRandom(world, (int)Math.round(x), (int)Math.round(y), (int)Math.round(z), area / 4)) != null) {
                if (forceGlobal) {
                    spirit.setGlobalVengeance(true);
                } else {
                    spirit.setEnabledVengeance((EntityPlayer)entity, true);
                }
                spirit.func_70784_b(entity);
                int chance = VengeanceSpiritConfig.nonDegradedSpawnChance;
                spirit.setIsSwarm(chance <= 0 || world.field_73012_v.nextInt(chance) > 0);
            }
        }
    }

    public static void updateRingPowers(EntityPlayer player) {
        for (int[] power : RING_POWERS) {
            player.func_70690_d(new PotionEffect(power[0], power[1], power[2], true));
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer && !world.field_72995_K && WorldHelpers.efficientTick(world, 5, entity.func_145782_y())) {
            int area = VengeanceRingConfig.areaOfEffect;
            VengeanceRing.toggleVengeanceArea(world, entity, area, ItemHelpers.isActivated(itemStack), true, false);
            if (ItemHelpers.isActivated(itemStack)) {
                VengeanceRing.updateRingPowers((EntityPlayer)entity);
            }
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        L10NHelpers.addStatusInfo(list, ItemHelpers.isActivated(itemStack), this.func_77658_a() + ".info.status");
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemStack, EntityLivingBase entity) {
        return BaublesModCompat.canUse();
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemStack, EntityLivingBase entity) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemStack, EntityLivingBase entity) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemStack, EntityLivingBase entity) {
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack itemStack, EntityLivingBase entity) {
        if (BaublesModCompat.canUse()) {
            this.func_77663_a(itemStack, entity.field_70170_p, (Entity)entity, 0, false);
        }
    }
}

