/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.config.configurable.ConfigurableItem;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.core.helper.RenderHelpers;
import evilcraft.core.weather.WeatherType;
import evilcraft.entity.item.EntityWeatherContainer;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class WeatherContainer
extends ConfigurableItem {
    private static WeatherContainer _instance = null;
    private IIcon overlay;

    public static void initInstance(ExtendedConfig<ItemConfig> eConfig) {
        if (_instance == null) {
            _instance = new WeatherContainer(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static WeatherContainer getInstance() {
        return _instance;
    }

    private WeatherContainer(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.bow;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromDamage(int damage) {
        return WeatherContainer.getWeatherContainerType(damage).damageRenderColor;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int renderPass) {
        return renderPass > 0 ? 0xFFFFFF : this.getColorFromDamage(itemStack.func_77960_j());
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K && WeatherContainer.getWeatherContainerType(itemStack) != WeatherContainerTypes.EMPTY) {
            world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            world.func_72838_d((Entity)new EntityWeatherContainer(world, (EntityLivingBase)player, itemStack.func_77946_l()));
            --itemStack.field_77994_a;
        }
        return itemStack;
    }

    public void onUse(World world, ItemStack itemStack) {
        WeatherContainer.getWeatherContainerType(itemStack).onUse(world, itemStack);
    }

    public void onFill(World world, ItemStack itemStack) {
        WeatherContainer.getWeatherContainerType(itemStack).onFill(world, itemStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        WeatherContainerTypes type = WeatherContainer.getWeatherContainerType(itemStack);
        list.add(type.damageColor + type.description);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A());
        this.overlay = iconRegister.func_94245_a(this.func_111208_A() + "_overlay");
    }

    public IIcon func_77618_c(int meta, int renderpass) {
        return renderpass == 0 ? this.overlay : super.func_77618_c(meta, renderpass);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < WeatherContainerTypes.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public static boolean isEmpty(int itemDamage) {
        return itemDamage == WeatherContainerTypes.EMPTY.ordinal();
    }

    public static WeatherContainerTypes getWeatherContainerType(int damage) {
        if (damage > WeatherContainerTypes.values().length) {
            return WeatherContainerTypes.EMPTY;
        }
        return WeatherContainerTypes.values()[damage];
    }

    public static WeatherContainerTypes getWeatherContainerType(ItemStack stack) {
        return WeatherContainer.getWeatherContainerType(stack.func_77960_j());
    }

    public static ItemStack createItemStack(WeatherContainerTypes type, int amount) {
        return new ItemStack((Item)WeatherContainer.getInstance(), amount, type.ordinal());
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return itemStack.func_77960_j() == 0 ? EnumRarity.common : (itemStack.func_77960_j() > 2 ? EnumRarity.rare : EnumRarity.uncommon);
    }

    public static enum WeatherContainerTypes {
        EMPTY(null, "empty", EnumChatFormatting.GRAY, RenderHelpers.RGBToInt(125, 125, 125)),
        CLEAR(WeatherType.CLEAR, "clear", EnumChatFormatting.AQUA, RenderHelpers.RGBToInt(30, 150, 230)),
        RAIN(WeatherType.RAIN, "rain", EnumChatFormatting.DARK_BLUE, RenderHelpers.RGBToInt(0, 0, 255)),
        LIGHTNING(WeatherType.LIGHTNING, "lightning", EnumChatFormatting.GOLD, RenderHelpers.RGBToInt(255, 215, 0));

        private final WeatherType type;
        private final String description;
        private final EnumChatFormatting damageColor;
        private final int damageRenderColor;

        private WeatherContainerTypes(WeatherType type, String description, EnumChatFormatting damageColor, int damageRenderColor) {
            this.type = type;
            this.description = L10NHelpers.localize("weatherContainer." + description);
            this.damageColor = damageColor;
            this.damageRenderColor = damageRenderColor;
        }

        public void onFill(World world, ItemStack containerStack) {
            WeatherContainerTypes currentWeatherType = EMPTY;
            for (WeatherContainerTypes type : WeatherContainerTypes.values()) {
                if (type.type == null || !type.type.isActive(world)) continue;
                currentWeatherType = type;
            }
            containerStack.func_77964_b(currentWeatherType.ordinal());
            currentWeatherType.type.deactivate(world);
        }

        public void onUse(World world, ItemStack containerStack) {
            if (world.field_72995_K) {
                return;
            }
            if (this.type != null) {
                this.type.activate(world);
            }
            containerStack.func_77964_b(EMPTY.ordinal());
        }

        public static WeatherContainerTypes getWeatherContainerType(WeatherType weatherType) {
            for (WeatherContainerTypes type : WeatherContainerTypes.values()) {
                if (type.type != weatherType) continue;
                return type;
            }
            return null;
        }
    }
}

