/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.modcompat.bloodmagic;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.core.fluid.BloodFluidConverter;
import evilcraft.core.helper.ItemHelpers;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.fluid.Blood;
import evilcraft.modcompat.bloodmagic.BoundBloodDropConfig;
import evilcraft.modcompat.bloodmagic.ClientSoulNetworkHandler;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class BoundBloodDrop
extends ConfigurableDamageIndicatedItemFluidContainer {
    private static BoundBloodDrop _instance = null;

    public static void initInstance(ExtendedConfig<ItemConfig> eConfig) {
        if (_instance == null) {
            _instance = new BoundBloodDrop(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static BoundBloodDrop getInstance() {
        return _instance;
    }

    private BoundBloodDrop(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, 1000, Blood.getInstance());
        this.setPlaceFluids(true);
    }

    private static String getOwnerName(ItemStack item) {
        if (item.field_77990_d == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        return item.field_77990_d.func_74779_i("ownerName");
    }

    private static int getCurrentEssence(String owner) {
        return ClientSoulNetworkHandler.getInstance().getCurrentEssence(owner);
    }

    public boolean hasEffect(ItemStack itemStack, int pass) {
        return ItemHelpers.isActivated(itemStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        itemList.add(new ItemStack((Item)this));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        L10NHelpers.addStatusInfo(list, ItemHelpers.isActivated(itemStack), this.func_77658_a() + ".info.autoSupply");
        if (itemStack.func_77978_p() != null) {
            String owner = BoundBloodDrop.getOwnerName(itemStack);
            if (owner == null || owner.isEmpty()) {
                owner = EnumChatFormatting.ITALIC + L10NHelpers.localize(this.func_77658_a() + ".info.currentOwner.none");
            }
            list.add(L10NHelpers.localize(this.func_77658_a() + ".info.currentOwner", owner));
        }
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        SoulNetworkHandler.checkAndSetItemOwner((ItemStack)itemStack, (EntityPlayer)player);
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemHelpers.toggleActivation(itemStack);
            }
            return itemStack;
        }
        return super.func_77659_a(itemStack, world, player);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (ItemHelpers.isActivated(itemStack)) {
            ItemHelpers.updateAutoFill((IFluidContainerItem)this, itemStack, world, entity);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public int getCapacity(ItemStack container) {
        FluidStack contents = this.getFluid(container);
        int contentsAmount = contents == null ? 0 : contents.amount;
        return Math.max(contentsAmount, BoundBloodDropConfig.maxCapacity);
    }

    public FluidStack getFluid(ItemStack container) {
        String owner = BoundBloodDrop.getOwnerName(container);
        int essence = 0;
        if (owner != null && !owner.isEmpty()) {
            essence = BoundBloodDrop.getCurrentEssence(owner);
        }
        FluidStack drainedEssence = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, essence);
        return BloodFluidConverter.getInstance().convert(drainedEssence);
    }

    @Override
    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        int filled;
        String owner = BoundBloodDrop.getOwnerName(container);
        if (owner == null || owner.isEmpty()) {
            return 0;
        }
        int essence = BoundBloodDrop.getCurrentEssence(owner);
        FluidStack essenceFluid = BloodFluidConverter.getInstance().convertReverse(AlchemicalWizardry.lifeEssenceFluid, resource);
        int n = filled = essenceFluid == null ? 0 : essenceFluid.amount;
        if (doFill && !MinecraftHelpers.isClientSide()) {
            SoulNetworkHandler.setCurrentEssence((String)owner, (int)(essence + filled));
        }
        return filled;
    }

    @Override
    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        String owner = BoundBloodDrop.getOwnerName(container);
        if (owner == null || owner.isEmpty()) {
            return null;
        }
        int essence = BoundBloodDrop.getCurrentEssence(owner);
        FluidStack toDrain = new FluidStack((Fluid)Blood.getInstance(), maxDrain);
        FluidStack toDrainEssence = BloodFluidConverter.getInstance().convertReverse(AlchemicalWizardry.lifeEssenceFluid, toDrain);
        int drainEssence = Math.min(essence, toDrainEssence == null ? 0 : toDrainEssence.amount);
        if (doDrain && !MinecraftHelpers.isClientSide()) {
            SoulNetworkHandler.setCurrentEssence((String)owner, (int)(essence - drainEssence));
        }
        FluidStack drainedEssence = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, drainEssence);
        return BloodFluidConverter.getInstance().convert(drainedEssence);
    }
}

