/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.modcompat.bloodmagic;

import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.helper.WorldHelpers;
import evilcraft.modcompat.bloodmagic.BoundBloodDropConfig;
import evilcraft.modcompat.bloodmagic.RequestSoulNetworkUpdatesPacket;
import evilcraft.modcompat.bloodmagic.UpdateSoulNetworkCachePacket;
import evilcraft.network.PacketHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;

public class ClientSoulNetworkHandler {
    private static ClientSoulNetworkHandler _instance = null;
    private Map<String, Integer> PLAYER_CACHE = Maps.newHashMap();
    private Set<String> UPDATE_PLAYERS = Sets.newHashSet();

    private ClientSoulNetworkHandler() {
    }

    public static void reset() {
        ClientSoulNetworkHandler.getInstance().PLAYER_CACHE = Maps.newHashMap();
    }

    public static ClientSoulNetworkHandler getInstance() {
        if (_instance == null) {
            _instance = new ClientSoulNetworkHandler();
        }
        return _instance;
    }

    public int getCurrentEssence(String owner) {
        if (MinecraftHelpers.isClientSide()) {
            Integer ret = this.PLAYER_CACHE.get(owner);
            if (ret == null) {
                PacketHandler.sendToServer(new RequestSoulNetworkUpdatesPacket(owner));
                return 0;
            }
            return ret;
        }
        int essence = SoulNetworkHandler.getCurrentEssence((String)owner);
        return essence;
    }

    public void setCurrentEssence(String owner, int currentEssence) {
        this.PLAYER_CACHE.put(owner, currentEssence);
    }

    public void addUpdatePlayer(String player) {
        this.UPDATE_PLAYERS.add(player);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && WorldHelpers.efficientTick((World)MinecraftServer.func_71276_C().field_71305_c[0], BoundBloodDropConfig.maxUpdateTicks, new int[0])) {
            HashMap toSend = Maps.newHashMap();
            for (String player : this.UPDATE_PLAYERS) {
                int essence = SoulNetworkHandler.getCurrentEssence((String)player);
                Integer found = this.PLAYER_CACHE.get(player);
                if (found != null && essence == found) continue;
                toSend.put(player, essence);
                this.setCurrentEssence(player, essence);
            }
            this.sendUpdates(toSend);
        }
    }

    private void sendUpdates(Map<String, Integer> toSend) {
        PacketHandler.sendToAll(new UpdateSoulNetworkCachePacket(toSend));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.field_72995_K) {
            ClientSoulNetworkHandler.reset();
        }
    }
}

