/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.modcompat.thermalexpansion;

import cpw.mods.fml.common.event.FMLInterModComms;
import evilcraft.Configs;
import evilcraft.EvilCraft;
import evilcraft.IInitListener;
import evilcraft.Recipes;
import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.block.BloodInfuser;
import evilcraft.block.BloodInfuserConfig;
import evilcraft.block.DarkOre;
import evilcraft.block.DarkOreConfig;
import evilcraft.block.UndeadLogConfig;
import evilcraft.block.UndeadPlankConfig;
import evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;
import evilcraft.core.recipe.custom.ItemStackRecipeComponent;
import evilcraft.fluid.Blood;
import evilcraft.fluid.Poison;
import evilcraft.item.BloodWaxedCoalConfig;
import evilcraft.item.DarkGem;
import evilcraft.item.DarkGemConfig;
import evilcraft.item.DarkGemCrushedConfig;
import evilcraft.item.EnderTearConfig;
import evilcraft.item.HardenedBloodShardConfig;
import evilcraft.modcompat.IModCompat;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ThermalExpansionModCompat
implements IModCompat {
    @Override
    public String getModID() {
        return "ThermalExpansion";
    }

    @Override
    public void onInit(IInitListener.Step step) {
        if (step == IInitListener.Step.INIT) {
            this.registerThermalExpansionRecipes();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void registerThermalExpansionRecipes() {
        Fluid ender;
        String TE = this.getModID();
        EvilCraft.log("Registering " + TE + " recipes");
        if (Configs.isEnabled(UndeadLogConfig.class) && Configs.isEnabled(UndeadPlankConfig.class)) {
            NBTTagCompound sawmillUndeadWood = new NBTTagCompound();
            sawmillUndeadWood.func_74768_a("energy", 2000);
            sawmillUndeadWood.func_74782_a("input", (NBTBase)new NBTTagCompound());
            sawmillUndeadWood.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
            new ItemStack(UndeadLogConfig._instance.getBlockInstance()).func_77955_b(sawmillUndeadWood.func_74775_l("input"));
            new ItemStack(UndeadPlankConfig._instance.getBlockInstance(), 6).func_77955_b(sawmillUndeadWood.func_74775_l("primaryOutput"));
            FMLInterModComms.sendMessage((String)TE, (String)"SawmillRecipe", (NBTTagCompound)sawmillUndeadWood);
        }
        if (Configs.isEnabled(DarkOreConfig.class) && Configs.isEnabled(DarkGemConfig.class)) {
            boolean crushedEnabled = Configs.isEnabled(DarkGemCrushedConfig.class);
            NBTTagCompound pulverizerDarkOre = new NBTTagCompound();
            pulverizerDarkOre.func_74768_a("energy", 2000);
            pulverizerDarkOre.func_74782_a("input", (NBTBase)new NBTTagCompound());
            pulverizerDarkOre.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
            if (crushedEnabled) {
                pulverizerDarkOre.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
                pulverizerDarkOre.func_74768_a("secondaryChance", 30);
            }
            new ItemStack((Block)DarkOre.getInstance()).func_77955_b(pulverizerDarkOre.func_74775_l("input"));
            new ItemStack((Item)DarkGem.getInstance(), 2).func_77955_b(pulverizerDarkOre.func_74775_l("primaryOutput"));
            if (crushedEnabled) {
                new ItemStack(DarkGemCrushedConfig._instance.getItemInstance(), 1).func_77955_b(pulverizerDarkOre.func_74775_l("secondaryOutput"));
            }
            FMLInterModComms.sendMessage((String)TE, (String)"PulverizerRecipe", (NBTTagCompound)pulverizerDarkOre);
        }
        if (Configs.isEnabled(DarkGemConfig.class) && Configs.isEnabled(DarkGemCrushedConfig.class)) {
            NBTTagCompound pulverizerDarkOre = new NBTTagCompound();
            pulverizerDarkOre.func_74768_a("energy", 4000);
            pulverizerDarkOre.func_74782_a("input", (NBTBase)new NBTTagCompound());
            pulverizerDarkOre.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
            new ItemStack((Item)DarkGem.getInstance()).func_77955_b(pulverizerDarkOre.func_74775_l("input"));
            new ItemStack(DarkGemCrushedConfig._instance.getItemInstance(), 1).func_77955_b(pulverizerDarkOre.func_74775_l("primaryOutput"));
            FMLInterModComms.sendMessage((String)TE, (String)"PulverizerRecipe", (NBTTagCompound)pulverizerDarkOre);
        }
        ArrayList materialPoisonousList = OreDictionary.getOres((String)"materialPoisonous");
        for (ItemStack itemStack : materialPoisonousList) {
            void var4_5;
            NBTTagCompound cruciblePoison = new NBTTagCompound();
            cruciblePoison.func_74768_a("energy", 2000);
            cruciblePoison.func_74782_a("input", (NBTBase)new NBTTagCompound());
            cruciblePoison.func_74782_a("output", (NBTBase)new NBTTagCompound());
            if (itemStack.func_77960_j() == Short.MAX_VALUE) {
                ItemStack itemStack2 = itemStack.func_77946_l();
                itemStack2.func_77964_b(0);
            }
            var4_5.func_77955_b(cruciblePoison.func_74775_l("input"));
            new FluidStack((Fluid)Poison.getInstance(), 250).writeToNBT(cruciblePoison.func_74775_l("output"));
            FMLInterModComms.sendMessage((String)TE, (String)"CrucibleRecipe", (NBTTagCompound)cruciblePoison);
        }
        if (Configs.isEnabled(EnderTearConfig.class) && (ender = FluidRegistry.getFluid((String)"ender")) != null) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("energy", 40000);
            nBTTagCompound.func_74782_a("input", (NBTBase)new NBTTagCompound());
            nBTTagCompound.func_74782_a("output", (NBTBase)new NBTTagCompound());
            new ItemStack(EnderTearConfig._instance.getItemInstance()).func_77955_b(nBTTagCompound.func_74775_l("input"));
            new FluidStack(ender, EnderTearConfig.mbLiquidEnder).writeToNBT(nBTTagCompound.func_74775_l("output"));
            FMLInterModComms.sendMessage((String)TE, (String)"CrucibleRecipe", (NBTTagCompound)nBTTagCompound);
        }
        if (Configs.isEnabled(HardenedBloodShardConfig.class)) {
            NBTTagCompound crucibleBloodShard = new NBTTagCompound();
            crucibleBloodShard.func_74768_a("energy", 200);
            crucibleBloodShard.func_74782_a("input", (NBTBase)new NBTTagCompound());
            crucibleBloodShard.func_74782_a("output", (NBTBase)new NBTTagCompound());
            new ItemStack(HardenedBloodShardConfig._instance.getItemInstance()).func_77955_b(crucibleBloodShard.func_74775_l("input"));
            new FluidStack((Fluid)Blood.getInstance(), 100).writeToNBT(crucibleBloodShard.func_74775_l("output"));
            FMLInterModComms.sendMessage((String)TE, (String)"CrucibleRecipe", (NBTTagCompound)crucibleBloodShard);
        }
        if (Configs.isEnabled(BloodInfuserConfig.class)) {
            for (IRecipe iRecipe : BloodInfuser.getInstance().getRecipeRegistry().allRecipes()) {
                if (((ItemFluidStackAndTierRecipeComponent)iRecipe.getInput()).getTier() != 0) continue;
                NBTTagCompound bloodInfuse = new NBTTagCompound();
                bloodInfuse.func_74768_a("energy", ((DurationXpRecipeProperties)iRecipe.getProperties()).getDuration() * 10);
                bloodInfuse.func_74782_a("input", (NBTBase)new NBTTagCompound());
                bloodInfuse.func_74782_a("output", (NBTBase)new NBTTagCompound());
                bloodInfuse.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
                ((ItemFluidStackAndTierRecipeComponent)iRecipe.getInput()).getItemStack().func_77955_b(bloodInfuse.func_74775_l("input"));
                ((ItemStackRecipeComponent)iRecipe.getOutput()).getItemStack().func_77955_b(bloodInfuse.func_74775_l("output"));
                bloodInfuse.func_74757_a("reversible", false);
                FluidStack fluid = ((ItemFluidStackAndTierRecipeComponent)iRecipe.getInput()).getFluidStack().copy();
                fluid.amount = (int)((double)fluid.amount * 1.5);
                fluid.writeToNBT(bloodInfuse.func_74775_l("fluid"));
                FMLInterModComms.sendMessage((String)TE, (String)"TransposerFillRecipe", (NBTTagCompound)bloodInfuse);
            }
        }
        for (Map.Entry entry : Recipes.BUCKETS.entrySet()) {
            NBTTagCompound fill = new NBTTagCompound();
            fill.func_74768_a("energy", 2000);
            fill.func_74782_a("input", (NBTBase)new NBTTagCompound());
            fill.func_74782_a("output", (NBTBase)new NBTTagCompound());
            fill.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
            new ItemStack((Item)entry.getKey()).func_77955_b(fill.func_74775_l("input"));
            new ItemStack(Items.field_151133_ar).func_77955_b(fill.func_74775_l("output"));
            fill.func_74757_a("reversible", true);
            ((FluidStack)entry.getValue()).copy().writeToNBT(fill.func_74775_l("fluid"));
            FMLInterModComms.sendMessage((String)TE, (String)"TransposerFillRecipe", (NBTTagCompound)fill);
        }
        if (Configs.isEnabled(BloodWaxedCoalConfig.class)) {
            NBTTagCompound pulverizerDustCoal = new NBTTagCompound();
            pulverizerDustCoal.func_74768_a("energy", 2400);
            pulverizerDustCoal.func_74782_a("input", (NBTBase)new NBTTagCompound());
            pulverizerDustCoal.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
            new ItemStack(BloodWaxedCoalConfig._instance.getItemInstance()).func_77955_b(pulverizerDustCoal.func_74775_l("input"));
            ArrayList arrayList = OreDictionary.getOres((String)"dustCoal");
            if (!arrayList.isEmpty()) {
                ItemStack dustCoal = ((ItemStack)arrayList.get(0)).func_77946_l();
                dustCoal.field_77994_a = 2;
                dustCoal.func_77955_b(pulverizerDustCoal.func_74775_l("primaryOutput"));
                ArrayList sulfurList = OreDictionary.getOres((String)"dustSulfur");
                if (!sulfurList.isEmpty()) {
                    pulverizerDustCoal.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
                    pulverizerDustCoal.func_74768_a("secondaryChance", 20);
                    ItemStack dustSulfur = ((ItemStack)sulfurList.get(0)).func_77946_l();
                    dustSulfur.field_77994_a = 1;
                    dustSulfur.func_77955_b(pulverizerDustCoal.func_74775_l("secondaryOutput"));
                }
                FMLInterModComms.sendMessage((String)TE, (String)"PulverizerRecipe", (NBTTagCompound)pulverizerDustCoal);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getComment() {
        return "Sawmill, Pulverizer, Magma Crucible and Fluid Transposer recipes.";
    }
}

