/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.modcompat.waila;

import evilcraft.Configs;
import evilcraft.block.BloodStainedBlock;
import evilcraft.block.BloodStainedBlockConfig;
import evilcraft.block.BoxOfEternalClosureConfig;
import evilcraft.block.NetherfishSpawn;
import evilcraft.block.NetherfishSpawnConfig;
import evilcraft.core.config.configurable.IConfigurable;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.core.tileentity.TankInventoryTileEntity;
import evilcraft.modcompat.waila.BoxOfEternalClosureDataProvider;
import evilcraft.modcompat.waila.GenericBlockInfoDataProvider;
import evilcraft.modcompat.waila.InnerBlockDataProvider;
import evilcraft.modcompat.waila.TankDataProvider;
import evilcraft.tileentity.TileBoxOfEternalClosure;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;

public class Waila {
    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.addConfig("EvilCraft", Waila.getTankConfigID(), L10NHelpers.localize("gui.waila.tankConfig"));
        registrar.addConfig("EvilCraft", Waila.getInnerBlockConfigID(), L10NHelpers.localize("gui.waila.innerBlocksConfig"));
        registrar.addConfig("EvilCraft", Waila.getBoxOfEternalClosureConfigID(), L10NHelpers.localize("gui.waila.boxOfEternalClosureConfig"));
        registrar.addConfig("EvilCraft", Waila.getBlockInfoConfigID(), L10NHelpers.localize("gui.waila.blockInfoConfig"));
        registrar.registerBodyProvider((IWailaDataProvider)new TankDataProvider(), TankInventoryTileEntity.class);
        if (Configs.isEnabled(BloodStainedBlockConfig.class)) {
            registrar.registerStackProvider((IWailaDataProvider)new InnerBlockDataProvider(), BloodStainedBlock.class);
        }
        if (Configs.isEnabled(NetherfishSpawnConfig.class)) {
            registrar.registerStackProvider((IWailaDataProvider)new InnerBlockDataProvider(), NetherfishSpawn.class);
        }
        if (Configs.isEnabled(BoxOfEternalClosureConfig.class)) {
            registrar.registerSyncedNBTKey("spiritTag", TileBoxOfEternalClosure.class);
            registrar.registerBodyProvider((IWailaDataProvider)new BoxOfEternalClosureDataProvider(), TileBoxOfEternalClosure.class);
        }
        registrar.registerBodyProvider((IWailaDataProvider)new GenericBlockInfoDataProvider(), IConfigurable.class);
    }

    public static String getTankConfigID() {
        return "EvilCraft.tank";
    }

    public static String getInnerBlockConfigID() {
        return "EvilCraft.innerBlock";
    }

    public static String getBoxOfEternalClosureConfigID() {
        return "EvilCraft.boxOfEternalClosure";
    }

    public static String getBlockInfoConfigID() {
        return "EvilCraft.genericBlockInfo";
    }
}

