/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.network.packet;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.Achievements;
import evilcraft.GeneralConfig;
import evilcraft.client.particle.EntityFartFX;
import evilcraft.core.helper.LocationHelpers;
import evilcraft.network.CodecField;
import evilcraft.network.PacketCodec;
import evilcraft.network.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public class FartPacket
extends PacketCodec {
    private static final int FART_RANGE = 3000;
    private static final int MAX_PARTICLES = 200;
    private static final int MIN_PARTICLES = 100;
    private static final float CLIENT_PLAYER_Y_OFFSET = -0.8f;
    private static final float REMOTE_PLAYER_Y_OFFSET = 0.65f;
    private static final List<UUID> ALLOW_RAINBOW_FARTS = new ArrayList<UUID>();
    @CodecField
    private String displayName;
    @CodecField
    private double x = 0.0;
    @CodecField
    private double y = 0.0;
    @CodecField
    private double z = 0.0;

    public FartPacket() {
    }

    public FartPacket(EntityPlayer player) {
        this.displayName = player.getDisplayName();
        this.x = player.field_70165_t;
        this.y = player.field_70163_u;
        this.z = player.field_70161_v;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        if (GeneralConfig.farting) {
            boolean isRemotePlayer;
            boolean bl = isRemotePlayer = !player.getDisplayName().equals(this.displayName);
            if (isRemotePlayer) {
                player = world.func_72924_a(this.displayName);
                this.spawnFartParticles(world, player, this.x, this.y, this.z, true);
            } else {
                this.spawnFartParticles(world, player, false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnFartParticles(World world, EntityPlayer player, boolean isRemotePlayer) {
        this.spawnFartParticles(world, player, player.field_70165_t, player.field_70163_u, player.field_70161_v, isRemotePlayer);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnFartParticles(World world, EntityPlayer player, double posX, double posY, double posZ, boolean isRemotePlayer) {
        if (player == null) {
            return;
        }
        Random rand = world.field_73012_v;
        int numParticles = rand.nextInt(100) + 100;
        boolean rainbow = this.hasRainbowFart(player);
        double yaw = (double)player.field_70177_z * Math.PI / 180.0;
        double playerXOffset = Math.sin(yaw) * 0.7;
        double playerZOffset = -Math.cos(yaw) * 0.7;
        float playerYOffset = isRemotePlayer ? 0.65f : -0.8f;
        for (int i = 0; i < numParticles; ++i) {
            double extraDistance = (double)rand.nextFloat() % 0.3;
            double particleX = posX + playerXOffset + extraDistance;
            double particleY = posY + (double)playerYOffset;
            double particleZ = posZ + playerZOffset + extraDistance;
            float particleMotionX = -0.5f + rand.nextFloat();
            float particleMotionY = -0.5f + rand.nextFloat();
            float particleMotionZ = -0.5f + rand.nextFloat();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityFartFX(world, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ, rainbow));
        }
    }

    public boolean hasRainbowFart(EntityPlayer player) {
        return player.func_146103_bH() != null && ALLOW_RAINBOW_FARTS.contains(player.func_146103_bH().getId());
    }

    @Override
    public void actionServer(World world, EntityPlayerMP player) {
        if (GeneralConfig.farting) {
            player.func_71064_a((StatBase)Achievements.FART, 1);
            PacketHandler.sendToAllAround(new FartPacket((EntityPlayer)player), LocationHelpers.createTargetPointFromEntityPosition((Entity)player, 3000));
        }
    }

    static {
        ALLOW_RAINBOW_FARTS.add(UUID.fromString("068d4de0-3a75-4c6a-9f01-8c37e16a394c"));
        ALLOW_RAINBOW_FARTS.add(UUID.fromString("e1dc75c6-dcf9-4e0c-8fbf-9c6e5e44527c"));
        ALLOW_RAINBOW_FARTS.add(UUID.fromString("777e7aa3-9373-4511-8d75-f99d23ebe252"));
    }
}

