/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.network.packet;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.client.particle.EntityFireShootFX;
import evilcraft.core.helper.LocationHelpers;
import evilcraft.network.CodecField;
import evilcraft.network.PacketCodec;
import evilcraft.network.PacketHandler;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFlameFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public class RingOfFirePacket
extends PacketCodec {
    private static final int RANGE = 3000;
    private static double RING_AREA = 0.9f;
    @CodecField
    private String displayName;
    @CodecField
    private double x = 0.0;
    @CodecField
    private double y = 0.0;
    @CodecField
    private double z = 0.0;

    public RingOfFirePacket() {
    }

    public RingOfFirePacket(EntityPlayer player) {
        this.displayName = player.getDisplayName();
        this.x = player.field_70165_t;
        this.y = player.field_70163_u;
        this.z = player.field_70161_v;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        if (!player.getDisplayName().equals(this.displayName)) {
            player = world.func_72924_a(this.displayName);
        }
        if (player != null) {
            RingOfFirePacket.showFireRing((Entity)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void showFireRing(Entity entity) {
        double area = RING_AREA;
        World world = entity.field_70170_p;
        int points = 40;
        for (double point = (double)(-points); point <= (double)points; point += 1.0) {
            double u = Math.PI * 2 * (point / (double)points);
            double xOffset = Math.cos(u) * area;
            double yOffset = 0.0;
            double zOffset = Math.sin(u) * area;
            double xCoord = entity.field_70165_t;
            double yCoord = entity.field_70163_u - 1.0;
            double zCoord = entity.field_70161_v;
            double particleX = xCoord + xOffset + (double)(world.field_73012_v.nextFloat() / 5.0f);
            double particleY = yCoord + yOffset + (double)(world.field_73012_v.nextFloat() / 5.0f);
            double particleZ = zCoord + zOffset + (double)(world.field_73012_v.nextFloat() / 5.0f);
            float particleMotionX = (float)xOffset / 5.0f;
            float particleMotionY = 0.25f;
            float particleMotionZ = (float)zOffset / 5.0f;
            if (world.field_73012_v.nextInt(20) == 0) {
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntityFireShootFX(world, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ, 0.1f));
                continue;
            }
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntityFlameFX(world, particleX, particleY, particleZ, 0.0, 0.0, 0.0));
        }
    }

    @Override
    public void actionServer(World world, EntityPlayerMP player) {
        PacketHandler.sendToAllAround(new RingOfFirePacket((EntityPlayer)player), LocationHelpers.createTargetPointFromEntityPosition((Entity)player, 3000));
    }
}

