/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.proxy;

import cpw.mods.fml.common.FMLCommonHandler;
import evilcraft.EvilCraft;
import evilcraft.api.ILocation;
import evilcraft.core.BucketHandler;
import evilcraft.core.fluid.WorldSharedTankCache;
import evilcraft.core.world.gen.RetroGenRegistry;
import evilcraft.event.BlockBreakEventHook;
import evilcraft.event.BonemealEventHook;
import evilcraft.event.ConfigChangedEventHook;
import evilcraft.event.EntityItemPickupEventHook;
import evilcraft.event.EntityStruckByLightningEventHook;
import evilcraft.event.FillBucketEventHook;
import evilcraft.event.ItemCraftedEventHook;
import evilcraft.event.LivingAttackEventHook;
import evilcraft.event.LivingDeathEventHook;
import evilcraft.event.LivingDropsEventHook;
import evilcraft.event.LivingSpawnEventHook;
import evilcraft.event.LivingUpdateEventHook;
import evilcraft.event.PlayerInteractEventHook;
import evilcraft.event.PlayerRingOfFire;
import evilcraft.network.PacketHandler;
import evilcraft.network.packet.DetectionListenerPacket;
import evilcraft.network.packet.ExaltedCrafterButtonPacket;
import evilcraft.network.packet.ExaltedCrafterOpenPacket;
import evilcraft.network.packet.FartPacket;
import evilcraft.network.packet.RingOfFirePacket;
import evilcraft.network.packet.SanguinaryPedestalBlockReplacePacket;
import evilcraft.network.packet.SoundPacket;
import evilcraft.network.packet.UpdateWorldSharedTankClientCachePacket;
import net.minecraftforge.common.MinecraftForge;

public class CommonProxy {
    protected static final String DEFAULT_RESOURCELOCATION_MOD = "minecraft";

    public void registerRenderers() {
    }

    public void registerKeyBindings() {
    }

    public void registerPacketHandlers() {
        PacketHandler.init();
        PacketHandler.register(FartPacket.class);
        PacketHandler.register(RingOfFirePacket.class);
        PacketHandler.register(DetectionListenerPacket.class);
        PacketHandler.register(SoundPacket.class);
        PacketHandler.register(SanguinaryPedestalBlockReplacePacket.class);
        PacketHandler.register(ExaltedCrafterButtonPacket.class);
        PacketHandler.register(ExaltedCrafterOpenPacket.class);
        PacketHandler.register(UpdateWorldSharedTankClientCachePacket.class);
        EvilCraft.log("Registered packet handler.");
    }

    public void registerTickHandlers() {
    }

    public void registerEventHooks() {
        MinecraftForge.EVENT_BUS.register((Object)BucketHandler.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)RetroGenRegistry.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)new LivingDeathEventHook());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerInteractEventHook());
        MinecraftForge.EVENT_BUS.register((Object)new LivingAttackEventHook());
        MinecraftForge.EVENT_BUS.register((Object)new BonemealEventHook());
        MinecraftForge.EVENT_BUS.register((Object)new EntityStruckByLightningEventHook());
        MinecraftForge.EVENT_BUS.register((Object)new LivingUpdateEventHook());
        MinecraftForge.EVENT_BUS.register((Object)new LivingDropsEventHook());
        MinecraftForge.EVENT_BUS.register((Object)new LivingSpawnEventHook());
        MinecraftForge.EVENT_BUS.register((Object)new FillBucketEventHook());
        MinecraftForge.EVENT_BUS.register((Object)new EntityItemPickupEventHook());
        MinecraftForge.EVENT_BUS.register((Object)new BlockBreakEventHook());
        FMLCommonHandler.instance().bus().register((Object)new ConfigChangedEventHook());
        FMLCommonHandler.instance().bus().register((Object)new PlayerRingOfFire());
        FMLCommonHandler.instance().bus().register((Object)new ItemCraftedEventHook());
        FMLCommonHandler.instance().bus().register((Object)WorldSharedTankCache.getInstance());
    }

    public void playSoundMinecraft(ILocation location, String sound, float volume, float frequency) {
        int[] c = location.getCoordinates();
        this.playSoundMinecraft(c[0], c[1], c[2], sound, volume, frequency);
    }

    public void playSoundMinecraft(double x, double y, double z, String sound, float volume, float frequency) {
        this.playSound(x, y, z, sound, volume, frequency, DEFAULT_RESOURCELOCATION_MOD);
    }

    public void playSound(double x, double y, double z, String sound, float volume, float frequency, String mod) {
    }

    public void playSound(double x, double y, double z, String sound, float volume, float frequency) {
        this.playSound(x, y, z, sound, volume, frequency, "evilcraft");
    }

    public void sendSoundMinecraft(ILocation location, String sound, float volume, float frequency) {
        int[] c = location.getCoordinates();
        this.sendSound(c[0], c[1], c[2], sound, volume, frequency, DEFAULT_RESOURCELOCATION_MOD);
    }

    public void sendSoundMinecraft(double x, double y, double z, String sound, float volume, float frequency) {
        this.sendSound(x, y, z, sound, volume, frequency, DEFAULT_RESOURCELOCATION_MOD);
    }

    public void sendSound(double x, double y, double z, String sound, float volume, float frequency, String mod) {
        SoundPacket packet = new SoundPacket(x, y, z, sound, volume, frequency, mod);
        PacketHandler.sendToServer(packet);
    }

    public void sendSound(double x, double y, double z, String sound, float volume, float frequency) {
        this.sendSound(x, y, z, sound, volume, frequency, "evilcraft");
    }
}

