/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity;

import evilcraft.block.BloodChest;
import evilcraft.core.fluid.BloodFluidConverter;
import evilcraft.core.fluid.ImplicitFluidConversionTank;
import evilcraft.core.fluid.SingleUseTank;
import evilcraft.core.helper.WorldHelpers;
import evilcraft.core.inventory.slot.SlotFluidContainer;
import evilcraft.core.tileentity.TickingTankInventoryTileEntity;
import evilcraft.core.tileentity.tickaction.ITickAction;
import evilcraft.core.tileentity.tickaction.TickComponent;
import evilcraft.fluid.Blood;
import evilcraft.inventory.container.ContainerBloodChest;
import evilcraft.inventory.slot.SlotRepairable;
import evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import evilcraft.tileentity.tickaction.EmptyItemBucketInTankTickAction;
import evilcraft.tileentity.tickaction.bloodchest.RepairItemTickAction;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileBloodChest
extends TickingTankInventoryTileEntity<TileBloodChest> {
    private static final int TICK_MODULUS = 200;
    public static final int SLOTS_CHEST = 10;
    public static final int SLOTS = 11;
    public static final int SLOT_CONTAINER = 10;
    public static String TANKNAME = "bloodChestTank";
    public static final int LIQUID_PER_SLOT = 10000;
    public static final int TICKS_PER_LIQUID = 2;
    public static final Fluid ACCEPTED_FLUID = Blood.getInstance();
    public float prevLidAngle;
    public float lidAngle;
    private int playersUsing;
    private Block block = BloodChest.getInstance();
    private static final Map<Class<?>, ITickAction<TileBloodChest>> REPAIR_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<TileBloodChest>> EMPTY_IN_TANK_TICK_ACTIONS;

    public TileBloodChest() {
        super(11, BloodChest.getInstance().func_149732_F(), 10000, TANKNAME, ACCEPTED_FLUID);
        for (int i = 0; i < 10; ++i) {
            this.addTicker(new TickComponent<TileBloodChest, ITickAction<TileBloodChest>>(this, REPAIR_TICK_ACTIONS, i));
        }
        this.addTicker(new TickComponent<TileBloodChest, ITickAction<TileBloodChest>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 10, false));
        LinkedList<Integer> inSlotsTank = new LinkedList<Integer>();
        inSlotsTank.add(10);
        LinkedList<Integer> inSlotsInventory = new LinkedList<Integer>();
        for (int i = 0; i < 10; ++i) {
            inSlotsInventory.add(i);
        }
        this.addSlotsToSide(ForgeDirection.EAST, inSlotsTank);
        this.addSlotsToSide(ForgeDirection.UP, inSlotsInventory);
        this.addSlotsToSide(ForgeDirection.DOWN, inSlotsInventory);
        this.addSlotsToSide(ForgeDirection.SOUTH, inSlotsInventory);
        this.addSlotsToSide(ForgeDirection.WEST, inSlotsInventory);
    }

    @Override
    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new ImplicitFluidConversionTank(tankName, tankSize, this, BloodFluidConverter.getInstance());
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 10) {
            return SlotFluidContainer.checkIsItemValid(itemStack, this.getTank());
        }
        if (slot <= 10 && slot >= 0) {
            return SlotRepairable.checkIsItemValid(itemStack);
        }
        return false;
    }

    @Override
    public int getNewState() {
        return 0;
    }

    @Override
    public void onStateChanged() {
    }

    @Override
    public void updateTileEntity() {
        super.updateTileEntity();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.playersUsing != 0 && WorldHelpers.efficientTick(this.field_145850_b, 200, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.playersUsing = 0;
            float range = 5.0f;
            List entities = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - range), (double)((float)this.field_145848_d - range), (double)((float)this.field_145849_e - range), (double)((float)(this.field_145851_c + 1) + range), (double)((float)(this.field_145848_d + 1) + range), (double)((float)(this.field_145849_e + 1) + range)));
            for (EntityPlayer player : entities) {
                if (!(player.field_71070_bA instanceof ContainerBloodChest)) continue;
                ++this.playersUsing;
            }
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.block, 1, this.playersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        float increaseAngle = 0.1f;
        if (this.playersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.playersUsing == 0 && this.lidAngle > 0.0f || this.playersUsing > 0 && this.lidAngle < 1.0f) {
            float closedAngle;
            float preIncreaseAngle = this.lidAngle;
            this.lidAngle = this.playersUsing > 0 ? (this.lidAngle += increaseAngle) : (this.lidAngle -= increaseAngle);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (closedAngle = 0.5f) && preIncreaseAngle >= closedAngle) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.playersUsing = j;
        }
        return true;
    }

    @Override
    public void func_70295_k_() {
        this.triggerPlayerUsageChange(1);
    }

    @Override
    public void func_70305_f() {
        this.triggerPlayerUsageChange(-1);
    }

    private void triggerPlayerUsageChange(int change) {
        if (this.field_145850_b != null) {
            this.playersUsing += change;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.block, 1, this.playersUsing);
        }
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return super.func_70300_a(entityPlayer) && (this.field_145850_b == null || this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this);
    }

    static {
        REPAIR_TICK_ACTIONS.put(Item.class, new RepairItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(IFluidContainerItem.class, new EmptyFluidContainerInTankTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyItemBucketInTankTickAction());
    }
}

