/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity;

import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.block.BloodInfuser;
import evilcraft.core.algorithm.SingleCache;
import evilcraft.core.fluid.BloodFluidConverter;
import evilcraft.core.fluid.ImplicitFluidConversionTank;
import evilcraft.core.fluid.SingleUseTank;
import evilcraft.core.inventory.slot.SlotFluidContainer;
import evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;
import evilcraft.core.recipe.custom.ItemStackRecipeComponent;
import evilcraft.core.tileentity.tickaction.ITickAction;
import evilcraft.core.tileentity.tickaction.TickComponent;
import evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import evilcraft.core.tileentity.upgrade.Upgrades;
import evilcraft.fluid.Blood;
import evilcraft.tileentity.TileWorking;
import evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import evilcraft.tileentity.tickaction.EmptyItemBucketInTankTickAction;
import evilcraft.tileentity.tickaction.bloodinfuser.FluidContainerItemTickAction;
import evilcraft.tileentity.tickaction.bloodinfuser.InfuseItemTickAction;
import evilcraft.tileentity.tickaction.bloodinfuser.ItemBucketTickAction;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Triple;

public class TileBloodInfuser
extends TileWorking<TileBloodInfuser, MutableInt> {
    public static final int SLOTS = 3;
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_INFUSE = 1;
    public static final int SLOT_INFUSE_RESULT = 2;
    public static String TANKNAME = "bloodInfuserTank";
    public static final int LIQUID_PER_SLOT = 10000;
    public static final int TICKS_PER_LIQUID = 2;
    public static final Fluid ACCEPTED_FLUID = Blood.getInstance();
    private int infuseTicker = this.addTicker(new TickComponent<TileBloodInfuser, ITickAction<TileBloodInfuser>>(this, INFUSE_TICK_ACTIONS, 1));
    private SingleCache<Triple<ItemStack, FluidStack, Integer>, IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties>> recipeCache;
    private static final Map<Class<?>, ITickAction<TileBloodInfuser>> INFUSE_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<TileBloodInfuser>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_FILLBLOODPERTICK;

    public TileBloodInfuser() {
        super(3, BloodInfuser.getInstance().func_149732_F(), 10000, TANKNAME, ACCEPTED_FLUID);
        this.addTicker(new TickComponent<TileBloodInfuser, ITickAction<TileBloodInfuser>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0, false));
        LinkedList<Integer> inSlots = new LinkedList<Integer>();
        inSlots.add(1);
        LinkedList<Integer> inSlotsTank = new LinkedList<Integer>();
        inSlotsTank.add(0);
        LinkedList<Integer> outSlots = new LinkedList<Integer>();
        outSlots.add(2);
        this.addSlotsToSide(ForgeDirection.EAST, inSlotsTank);
        this.addSlotsToSide(ForgeDirection.UP, inSlots);
        this.addSlotsToSide(ForgeDirection.NORTH, inSlots);
        this.addSlotsToSide(ForgeDirection.DOWN, outSlots);
        this.addSlotsToSide(ForgeDirection.SOUTH, outSlots);
        this.addSlotsToSide(ForgeDirection.WEST, outSlots);
        this.upgradeBehaviour.put(UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileBloodInfuser, MutableInt>(2.0){

            @Override
            public void applyUpgrade(TileBloodInfuser upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.upgradeBehaviour.put(UPGRADE_SPEED, new UpgradeBehaviour<TileBloodInfuser, MutableInt>(1.0){

            @Override
            public void applyUpgrade(TileBloodInfuser upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_FILLBLOODPERTICK) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val * (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                } else if (event.getType() == UPGRADEEVENT_SPEED) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.recipeCache = new SingleCache<Triple<ItemStack, FluidStack, Integer>, IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties>>(new SingleCache.ICacheUpdater<Triple<ItemStack, FluidStack, Integer>, IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties>>(){

            @Override
            public IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> getNewValue(Triple<ItemStack, FluidStack, Integer> key) {
                ItemFluidStackAndTierRecipeComponent recipeInput = new ItemFluidStackAndTierRecipeComponent((ItemStack)key.getLeft(), (FluidStack)key.getMiddle(), -1);
                IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> maxRecipe = null;
                int maxRecipeTier = -1;
                for (IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe : BloodInfuser.getInstance().getRecipeRegistry().findRecipesByInput(recipeInput)) {
                    if (recipe.getInput().getTier() <= maxRecipeTier || (Integer)key.getRight() < recipe.getInput().getTier()) continue;
                    maxRecipe = recipe;
                }
                return maxRecipe;
            }

            @Override
            public boolean isKeyEqual(Triple<ItemStack, FluidStack, Integer> cacheKey, Triple<ItemStack, FluidStack, Integer> newKey) {
                return cacheKey == null || newKey == null || ItemStack.func_77989_b((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.areFluidStackTagsEqual((FluidStack)((FluidStack)cacheKey.getMiddle()), (FluidStack)((FluidStack)newKey.getMiddle())) && ((Integer)cacheKey.getRight()).equals(newKey.getRight());
            }
        });
    }

    @Override
    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new ImplicitFluidConversionTank(tankName, tankSize, this, BloodFluidConverter.getInstance());
    }

    public IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> getRecipe(ItemStack itemStack) {
        return this.recipeCache.get((Triple<ItemStack, FluidStack, Integer>)Triple.of((Object)(itemStack == null ? null : itemStack.func_77946_l()), (Object)(this.getTank().getFluid() == null ? null : this.getTank().getFluid().copy()), (Object)this.getTier()));
    }

    @Override
    public boolean canConsume(ItemStack itemStack) {
        IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe;
        if (itemStack.func_77973_b() == Items.field_151133_ar && this.getTank().getFluidAmount() >= 1000) {
            return true;
        }
        if (itemStack.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)itemStack.func_77973_b();
            FluidStack fluidStack = container.getFluid(itemStack);
            if (fluidStack == null) {
                return true;
            }
            if (this.getTank().canTankAccept(fluidStack.getFluid()) && fluidStack.amount < container.getCapacity(itemStack)) {
                return true;
            }
        }
        return (recipe = this.getRecipe(itemStack)) != null;
    }

    public int getConsumeSlot() {
        return 1;
    }

    public int getProduceSlot() {
        return 2;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 1) {
            return this.canConsume(itemStack);
        }
        if (slot == 0) {
            return SlotFluidContainer.checkIsItemValid(itemStack, this.getTank());
        }
        return false;
    }

    @Override
    public void onStateChanged() {
        this.sendUpdate();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean canWork() {
        return true;
    }

    @Override
    protected int getWorkTicker() {
        return this.infuseTicker;
    }

    static {
        INFUSE_TICK_ACTIONS.put(ItemBucket.class, new ItemBucketTickAction());
        INFUSE_TICK_ACTIONS.put(IFluidContainerItem.class, new FluidContainerItemTickAction());
        INFUSE_TICK_ACTIONS.put(Item.class, new InfuseItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(IFluidContainerItem.class, new EmptyFluidContainerInTankTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyItemBucketInTankTickAction());
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_FILLBLOODPERTICK = Upgrades.newUpgradeEventType();
    }
}

