/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.EvilCraft;
import evilcraft.core.helper.WorldHelpers;
import evilcraft.core.tileentity.EvilCraftTileEntity;
import evilcraft.core.tileentity.NBTPersist;
import evilcraft.entity.monster.VengeanceSpirit;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileBoxOfEternalClosure
extends EvilCraftTileEntity {
    public static final String NBTKEY_SPIRIT = "spiritTag";
    public static final String NBTKEY_PLAYERID = "playerId";
    public static final String NBTKEY_PLAYERNAME = "playerName";
    private static final int TICK_MODULUS = 10;
    private static final int TARGET_RADIUS = 10;
    private static final double ABSORB_RADIUS = 0.5;
    private static final int NO_TARGET = -1;
    public static final float START_LID_ANGLE = 65.0f;
    private static final float LID_STEP = 11.5f;
    private EntityLivingBase spiritInstance = null;
    @NBTPersist
    private NBTTagCompound spiritTag = new NBTTagCompound();
    @NBTPersist
    private String playerId = "";
    @NBTPersist
    private String playerName = "";
    private VengeanceSpirit targetSpirit = null;
    @NBTPersist
    private Integer targetSpiritId = -1;
    @NBTPersist
    private Float lidAngle = Float.valueOf(65.0f);
    @NBTPersist
    private Boolean closing = true;
    private float previousLidAngle = 65.0f;
    private boolean initial = false;
    public int innerRotation = new Random().nextInt(100000);

    @Override
    public void updateTileEntity() {
        super.updateTileEntity();
        ++this.innerRotation;
        EntityLivingBase spirit = this.getSpiritInstance();
        VengeanceSpirit target = this.getTargetSpirit();
        if (spirit == null && !this.field_145850_b.field_72995_K && (target != null || WorldHelpers.efficientTick(this.func_145831_w(), 10, this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.findNextEntity())) {
            this.pullEntity();
        }
        if (this.field_145850_b.field_72995_K && target != null) {
            EvilCraft.proxy.playSound((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "boxBeam", 0.1f + this.field_145850_b.field_73012_v.nextFloat() * 0.9f, 0.1f + this.field_145850_b.field_73012_v.nextFloat() * 0.9f);
        }
        this.close(false);
    }

    private boolean findNextEntity() {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e).func_72314_b(10.0, 10.0, 10.0);
        List entities = this.field_145850_b.func_72872_a(VengeanceSpirit.class, box);
        double minDistance = 11.0;
        VengeanceSpirit closest = null;
        for (VengeanceSpirit spirit : entities) {
            double distance;
            if (!spirit.isFrozen() || spirit.isSwarm() || !((distance = spirit.func_70011_f(this.field_145851_c, this.field_145848_d, this.field_145849_e)) < minDistance)) continue;
            minDistance = distance;
            closest = spirit;
        }
        this.setTargetSpirit(closest);
        return this.targetSpirit != null;
    }

    private void pullEntity() {
        VengeanceSpirit target = this.getTargetSpirit();
        if (target != null) {
            double dx = this.targetSpirit.field_70165_t - (double)this.field_145851_c - 0.5;
            double dy = this.targetSpirit.field_70163_u - (double)this.field_145848_d - 0.5;
            double dz = this.targetSpirit.field_70161_v - (double)this.field_145849_e - 0.5;
            double distance = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
            if (target.field_70128_L || !target.isFrozen()) {
                this.setTargetSpirit(null);
            } else if (target.field_70121_D.func_72314_b(0.5, 0.5, 0.5).func_72326_a(this.getBlock().func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e))) {
                this.closing = true;
                this.close(true);
                this.setSpiritInstance((EntityLivingBase)this.targetSpirit);
                this.field_145850_b.func_72900_e((Entity)this.targetSpirit);
                this.playerId = this.targetSpirit.getPlayerId();
                this.playerName = this.targetSpirit.getPlayerName();
                this.setTargetSpirit(null);
            } else {
                double strength = 1.0 / distance / 50.0 + 0.01;
                target.field_70159_w -= dx * strength;
                target.field_70181_x -= dy * strength;
                target.field_70179_y -= dz * strength;
            }
        }
    }

    private void close(boolean force) {
        this.previousLidAngle = this.lidAngle.floatValue();
        if (this.lidAngle.floatValue() > 0.0f && this.lidAngle.floatValue() < 65.0f || force) {
            this.lidAngle = this.closing != false ? Float.valueOf(this.lidAngle.floatValue() - 11.5f) : Float.valueOf(this.lidAngle.floatValue() + 11.5f);
        }
        if (this.lidAngle.floatValue() < 0.0f) {
            this.lidAngle = Float.valueOf(0.0f);
            this.updateLight();
        }
        if (this.lidAngle.floatValue() > 65.0f) {
            this.lidAngle = Float.valueOf(65.0f);
            this.updateLight();
        }
    }

    public void releaseSpirit() {
        VengeanceSpirit spirit = new VengeanceSpirit(this.func_145831_w());
        spirit.func_82141_a((Entity)((VengeanceSpirit)this.spiritInstance), true);
        Random rand = this.field_145850_b.field_73012_v;
        spirit.func_70107_b((double)this.field_145851_c + rand.nextDouble(), (double)this.field_145848_d + rand.nextDouble(), (double)this.field_145849_e + rand.nextDouble());
        spirit.setFrozenDuration(0);
        spirit.setGlobalVengeance(true);
        spirit.setRemainingLife(MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)250, (int)1000));
        this.closing = false;
        this.close(true);
        this.clearSpiritInstance();
        this.field_145850_b.func_72838_d((Entity)spirit);
        spirit.func_110161_a(null);
    }

    public static EntityLivingBase getEntityFromNBT(World world, NBTTagCompound tag) {
        if (tag != null && tag.func_74764_b("id")) {
            return (EntityLivingBase)EntityList.func_75615_a((NBTTagCompound)tag, (World)world);
        }
        return null;
    }

    protected void setSpiritInstance(EntityLivingBase spiritInstance) {
        EntityLivingBase old = this.spiritInstance;
        this.spiritInstance = spiritInstance;
        if (spiritInstance != null) {
            spiritInstance.func_70109_d(this.spiritTag);
            String entityId = EntityList.func_75621_b((Entity)spiritInstance);
            this.spiritTag.func_74778_a("id", entityId);
        }
        if (old != spiritInstance) {
            if (old == null && !this.initial) {
                this.func_145831_w().func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestclosed", 0.5f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            this.sendUpdate();
        }
        this.initial = true;
    }

    protected void updateLight() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected void clearSpiritInstance() {
        EntityLivingBase old = this.spiritInstance;
        this.spiritInstance = null;
        this.spiritTag = new NBTTagCompound();
        if (old != null) {
            this.sendUpdate();
        }
    }

    public EntityLivingBase getSpiritInstance() {
        if (this.spiritInstance == null) {
            EntityLivingBase entity = TileBoxOfEternalClosure.getEntityFromNBT(this.func_145831_w(), this.spiritTag);
            this.setSpiritInstance(entity);
            if (!VengeanceSpirit.canSustain(entity) && entity != null && !(entity instanceof VengeanceSpirit)) {
                this.releaseSpirit();
            }
            if (this.spiritInstance == null) {
                this.closing = false;
                this.close(true);
            }
        }
        return this.spiritInstance;
    }

    public float getLidAngle() {
        return this.lidAngle.floatValue();
    }

    public float getPreviousLidAngle() {
        return this.previousLidAngle;
    }

    public VengeanceSpirit getTargetSpirit() {
        if (this.func_145831_w().field_72995_K && this.targetSpiritId == -1) {
            this.targetSpirit = null;
        } else if (this.targetSpirit == null && this.targetSpiritId != -1) {
            this.setTargetSpirit((VengeanceSpirit)this.func_145831_w().func_73045_a(this.targetSpiritId.intValue()));
        }
        return this.targetSpirit;
    }

    protected void setTargetSpirit(VengeanceSpirit targetSpirit) {
        VengeanceSpirit old = this.targetSpirit;
        this.targetSpirit = targetSpirit;
        this.targetSpiritId = targetSpirit != null ? Integer.valueOf(targetSpirit.func_145782_y()) : Integer.valueOf(-1);
        if (old != targetSpirit) {
            this.sendUpdate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    protected void onSendUpdate() {
        super.onSendUpdate();
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)this.getBlock());
    }
}

