/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.ILocation;
import evilcraft.block.ColossalBloodChest;
import evilcraft.block.ColossalBloodChestConfig;
import evilcraft.block.ReinforcedUndeadPlank;
import evilcraft.core.algorithm.Location;
import evilcraft.core.algorithm.Size;
import evilcraft.core.block.AllowedBlock;
import evilcraft.core.block.CubeDetector;
import evilcraft.core.block.HollowCubeDetector;
import evilcraft.core.fluid.BloodFluidConverter;
import evilcraft.core.fluid.ImplicitFluidConversionTank;
import evilcraft.core.fluid.SingleUseTank;
import evilcraft.core.helper.DirectionHelpers;
import evilcraft.core.helper.LocationHelpers;
import evilcraft.core.helper.WorldHelpers;
import evilcraft.core.inventory.slot.SlotFluidContainer;
import evilcraft.core.tileentity.NBTPersist;
import evilcraft.core.tileentity.tickaction.ITickAction;
import evilcraft.core.tileentity.tickaction.TickComponent;
import evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import evilcraft.core.tileentity.upgrade.Upgrades;
import evilcraft.fluid.Blood;
import evilcraft.inventory.container.ContainerColossalBloodChest;
import evilcraft.inventory.slot.SlotRepairable;
import evilcraft.tileentity.TileWorking;
import evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import evilcraft.tileentity.tickaction.EmptyItemBucketInTankTickAction;
import evilcraft.tileentity.tickaction.bloodchest.BulkRepairItemTickAction;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.mutable.MutableFloat;

public class TileColossalBloodChest
extends TileWorking<TileColossalBloodChest, MutableFloat> {
    private static final int TICK_MODULUS = 200;
    public static final int SLOTS_CHEST = 45;
    public static final int SLOTS = 46;
    public static final int SLOT_CONTAINER = 45;
    public static String TANKNAME = "colossalBloodChestTank";
    public static final int LIQUID_PER_SLOT = 10000;
    public static final int TICKS_PER_LIQUID = 2;
    public static final Fluid ACCEPTED_FLUID = Blood.getInstance();
    public static final int MAX_EFFICIENCY = 200;
    @NBTPersist
    private Size size = Size.NULL_SIZE.copy();
    @NBTPersist
    private ILocation renderOffset = Size.NULL_SIZE.copy();
    @NBTPersist
    private Integer efficiency = 0;
    private int repairTicker;
    public float prevLidAngle;
    public float lidAngle;
    private int playersUsing;
    private final Map<Integer, Boolean> slotTickHistory;
    private Block block = ColossalBloodChest.getInstance();
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
    private static final Map<Class<?>, ITickAction<TileColossalBloodChest>> REPAIR_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<TileColossalBloodChest>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static CubeDetector detector;

    public TileColossalBloodChest() {
        super(46, ColossalBloodChest.getInstance().func_149732_F(), 10000, TANKNAME, ACCEPTED_FLUID);
        for (int i = 0; i < 45; ++i) {
            this.addTicker(new TickComponent<TileColossalBloodChest, ITickAction<TileColossalBloodChest>>(this, REPAIR_TICK_ACTIONS, i));
        }
        this.addTicker(new TickComponent<TileColossalBloodChest, ITickAction<TileColossalBloodChest>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 45, false));
        LinkedList<Integer> inSlotsTank = new LinkedList<Integer>();
        inSlotsTank.add(45);
        LinkedList<Integer> inSlotsInventory = new LinkedList<Integer>();
        for (int i = 0; i < 45; ++i) {
            inSlotsInventory.add(i);
        }
        this.addSlotsToSide(ForgeDirection.EAST, inSlotsTank);
        this.addSlotsToSide(ForgeDirection.UP, inSlotsInventory);
        this.addSlotsToSide(ForgeDirection.DOWN, inSlotsInventory);
        this.addSlotsToSide(ForgeDirection.SOUTH, inSlotsInventory);
        this.addSlotsToSide(ForgeDirection.WEST, inSlotsInventory);
        this.upgradeBehaviour.put(UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileColossalBloodChest, MutableFloat>(2.0){

            @Override
            public void applyUpgrade(TileColossalBloodChest upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableFloat> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    float val = event.getObject().getValue().floatValue();
                    val = (float)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.upgradeBehaviour.put(UPGRADE_SPEED, new UpgradeBehaviour<TileColossalBloodChest, MutableFloat>(1.0){

            @Override
            public void applyUpgrade(TileColossalBloodChest upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableFloat> event) {
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    float val = event.getObject().getValue().floatValue();
                    val = (float)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.slotTickHistory = Maps.newHashMap();
        this.resetSlotHistory();
    }

    protected void resetSlotHistory() {
        for (int i = 0; i < this.getBasicInventorySize(); ++i) {
            this.slotTickHistory.put(i, false);
        }
    }

    @Override
    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new ImplicitFluidConversionTank(tankName, tankSize, this, BloodFluidConverter.getInstance());
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 45) {
            return SlotFluidContainer.checkIsItemValid(itemStack, this.getTank());
        }
        if (slot <= 45 && slot >= 0) {
            return SlotRepairable.checkIsItemValid(itemStack);
        }
        return false;
    }

    @Override
    public boolean canConsume(ItemStack itemStack) {
        return SlotRepairable.checkIsItemValid(itemStack);
    }

    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
        this.sendUpdate();
    }

    @Override
    public boolean canWork() {
        Size size = this.getSize();
        return size.compareTo(detector.getExactSize()) == 0;
    }

    public static boolean canWork(World world, ILocation location) {
        TileEntity tile = LocationHelpers.getTile((IBlockAccess)world, location);
        if (tile != null) {
            return ((TileColossalBloodChest)tile).canWork();
        }
        return false;
    }

    @Override
    protected int getWorkTicker() {
        return this.repairTicker;
    }

    @Override
    public int getNewState() {
        return 0;
    }

    @Override
    public void onStateChanged() {
    }

    @Override
    public void updateTileEntity() {
        this.resetSlotHistory();
        super.updateTileEntity();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.field_145850_b.func_72820_D() % (long)ColossalBloodChestConfig.ticksPerDamage == 0L) {
            int oldEfficiency = this.efficiency;
            this.efficiency = Math.max(0, this.efficiency - ColossalBloodChestConfig.baseConcurrentItems);
            if (oldEfficiency != this.efficiency) {
                this.sendUpdate();
            }
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.playersUsing != 0 && WorldHelpers.efficientTick(this.field_145850_b, 200, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.playersUsing = 0;
            float range = 5.0f;
            List entities = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - range), (double)((float)this.field_145848_d - range), (double)((float)this.field_145849_e - range), (double)((float)(this.field_145851_c + 1) + range), (double)((float)(this.field_145848_d + 1) + range), (double)((float)(this.field_145849_e + 1) + range)));
            for (EntityPlayer player : entities) {
                if (!(player.field_71070_bA instanceof ContainerColossalBloodChest)) continue;
                ++this.playersUsing;
            }
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.block, 1, this.playersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        float increaseAngle = 0.05f;
        if (this.playersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.5f);
        }
        if (this.playersUsing == 0 && this.lidAngle > 0.0f || this.playersUsing > 0 && this.lidAngle < 1.0f) {
            float closedAngle;
            float preIncreaseAngle = this.lidAngle;
            this.lidAngle = this.playersUsing > 0 ? (this.lidAngle += increaseAngle) : (this.lidAngle -= increaseAngle);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (closedAngle = 0.5f) && preIncreaseAngle >= closedAngle) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.5f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.playersUsing = j;
        }
        return true;
    }

    @Override
    public void func_70295_k_() {
        this.triggerPlayerUsageChange(1);
    }

    @Override
    public void func_70305_f() {
        this.triggerPlayerUsageChange(-1);
    }

    private void triggerPlayerUsageChange(int change) {
        if (this.field_145850_b != null) {
            this.playersUsing += change;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.block, 1, this.playersUsing);
        }
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return super.func_70300_a(entityPlayer) && (this.field_145850_b == null || this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)(this.field_145848_d - 3), (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 6), (double)(this.field_145849_e + 3));
    }

    public void setCenter(ILocation center) {
        ForgeDirection rotation = ForgeDirection.NORTH;
        int[] c = center.getCoordinates();
        if (c[0] != this.field_145851_c) {
            rotation = DirectionHelpers.getForgeDirectionFromXSign(c[0] - this.field_145851_c);
        } else if (c[2] != this.field_145849_e) {
            rotation = DirectionHelpers.getForgeDirectionFromZSing(c[2] - this.field_145849_e);
        }
        this.setRotation(rotation);
        this.renderOffset = new Location(this.field_145851_c, this.field_145848_d, this.field_145849_e).subtract(center);
    }

    public ILocation getRenderOffset() {
        return this.renderOffset;
    }

    public static void detectStructure(World world, ILocation location, Size size, boolean valid) {
        int newMeta = valid ? 1 : 0;
        boolean change = LocationHelpers.getBlockMeta(world, location) != newMeta;
        LocationHelpers.setBlockMetadata(world, location, newMeta, 2);
    }

    public Integer getEfficiency() {
        return this.efficiency;
    }

    public void setEfficiency(Integer efficiency) {
        this.efficiency = efficiency;
    }

    public Map<Integer, Boolean> getSlotTickHistory() {
        return this.slotTickHistory;
    }

    static {
        REPAIR_TICK_ACTIONS.put(Item.class, new BulkRepairItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(IFluidContainerItem.class, new EmptyFluidContainerInTankTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyItemBucketInTankTickAction());
        detector = new HollowCubeDetector(new AllowedBlock[]{new AllowedBlock(ReinforcedUndeadPlank.getInstance()), new AllowedBlock((Block)ColossalBloodChest.getInstance()).setExactOccurences(1)}, Lists.newArrayList((Object[])new Block[]{ColossalBloodChest.getInstance(), ReinforcedUndeadPlank.getInstance()})).setExactSize(new Size(2, 2, 2));
    }
}

