/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity;

import evilcraft.GeneralConfig;
import evilcraft.core.PlayerExtendedInventoryIterator;
import evilcraft.core.tileentity.TankInventoryTileEntity;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class TileDarkTank
extends TankInventoryTileEntity {
    public static final int BASE_CAPACITY = 16000;
    public static final String NBT_TAG_TANK = "darkTank";

    public TileDarkTank() {
        super(0, "inventory", 16000, NBT_TAG_TANK);
        this.setSendUpdateOnTankChanged(true);
    }

    public boolean func_94041_b(int side, ItemStack item) {
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[0];
    }

    public double getFillRatio() {
        return Math.min(1.0, (double)this.getTank().getFluidAmount() / (double)this.getTank().getCapacity());
    }

    protected boolean shouldAutoDrain() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1;
    }

    @Override
    protected void updateTileEntity() {
        block3: {
            ForgeDirection down;
            block4: {
                if (this.getTank().isEmpty() || !this.shouldAutoDrain() || this.func_145831_w().field_72995_K) break block3;
                down = ForgeDirection.DOWN;
                if (this.field_145850_b.func_147437_c(this.field_145851_c + down.offsetX, this.field_145848_d + down.offsetY, this.field_145849_e + down.offsetZ)) break block4;
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + down.offsetX, this.field_145848_d + down.offsetY, this.field_145849_e + down.offsetZ);
                if (!(tile instanceof IFluidHandler)) break block3;
                IFluidHandler handler = (IFluidHandler)tile;
                FluidStack fluidStack = new FluidStack(this.getTank().getFluidType(), Math.min(GeneralConfig.mbFlowRate, this.getTank().getFluidAmount()));
                if (handler.fill(down.getOpposite(), fluidStack, false) <= 0) break block3;
                int filled = handler.fill(down.getOpposite(), fluidStack, true);
                this.drain(filled, true);
                break block3;
            }
            List entities = this.field_145850_b.func_82733_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c + down.offsetX), (double)(this.field_145848_d + down.offsetY), (double)(this.field_145849_e + down.offsetZ), (double)(this.field_145851_c + down.offsetX + 1), (double)(this.field_145848_d + down.offsetY + 1), (double)(this.field_145849_e + down.offsetZ + 1)), IEntitySelector.field_94557_a);
            for (Entity entity : entities) {
                if (!this.getTank().isEmpty() && entity instanceof EntityItem) {
                    ItemStack itemStack;
                    ItemStack fillItemStack;
                    EntityItem item = (EntityItem)entity;
                    if (item.func_92059_d() == null || !(item.func_92059_d().func_77973_b() instanceof IFluidContainerItem) || item.func_92059_d().field_77994_a != 1 || (fillItemStack = this.fill(itemStack = item.func_92059_d().func_77946_l())) == null) continue;
                    item.func_92058_a(fillItemStack);
                    continue;
                }
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)entity;
                PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
                while (!this.getTank().isEmpty() && it.hasNext()) {
                    ItemStack fillItemStack;
                    ItemStack itemStack = it.next();
                    if (itemStack == null || !(itemStack.func_77973_b() instanceof IFluidContainerItem) || (fillItemStack = this.fill(itemStack)) == null) continue;
                    it.replace(fillItemStack);
                }
            }
        }
    }

    protected ItemStack fill(ItemStack itemStack) {
        FluidStack fluidStack;
        ItemStack fillItemStack = itemStack.func_77946_l();
        IFluidContainerItem container = (IFluidContainerItem)itemStack.func_77973_b();
        if (container.fill(fillItemStack, fluidStack = new FluidStack(this.getTank().getFluidType(), Math.min(GeneralConfig.mbFlowRate, this.getTank().getFluidAmount())), false) > 0) {
            int filled = container.fill(fillItemStack, fluidStack, true);
            this.drain(filled, true);
            return fillItemStack;
        }
        return null;
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.DOWN && super.canFill(from, fluid);
    }
}

