/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.ILocation;
import evilcraft.api.degradation.IDegradable;
import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.block.EnvironmentalAccumulator;
import evilcraft.block.EnvironmentalAccumulatorConfig;
import evilcraft.client.particle.EntityTargettedBlurFX;
import evilcraft.client.particle.ExtendedEntityBubbleFX;
import evilcraft.core.algorithm.Location;
import evilcraft.core.degradation.DegradationExecutor;
import evilcraft.core.helper.EntityHelpers;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.core.helper.LocationHelpers;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.inventory.SimpleInventory;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import evilcraft.core.weather.WeatherType;
import evilcraft.tileentity.EvilCraftBeaconTileEntity;
import evilcraft.tileentity.environmentalaccumulator.IEAProcessingFinishedEffect;
import java.util.List;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.util.vector.Vector4f;

public class TileEnvironmentalAccumulator
extends EvilCraftBeaconTileEntity
implements IBossDisplayData,
IDegradable,
IInventory {
    public static final int MAX_AGE = 50;
    public static final int SPREAD = 25;
    private static final int ITEM_MOVE_COOLDOWN_DURATION = 1;
    private static final double WEATHER_CONTAINER_MIN_DROP_HEIGHT = 0.0;
    private static final double WEATHER_CONTAINER_MAX_DROP_HEIGHT = 2.0;
    private static final double WEATHER_CONTAINER_SPAWN_HEIGHT = (double)EnvironmentalAccumulatorConfig.defaultProcessItemTickCount * EnvironmentalAccumulatorConfig.defaultProcessItemSpeed + 1.0;
    private static final float ITEM_MIN_SPAWN_HEIGHT = 1.0f;
    private static final int DEGRADATION_RADIUS_BASE = 5;
    private static final int DEGRADATION_TICK_INTERVAL = 100;
    private DegradationExecutor degradationExecutor = new DegradationExecutor(this);
    private int degradation = 0;
    private ILocation location = null;
    private static final ILocation[] waterOffsets = new ILocation[]{new Location(-2, -1, -2), new Location(-2, -1, 2), new Location(2, -1, -2), new Location(2, -1, 2)};
    private int state = 0;
    private int tick = 0;
    private SimpleInventory inventory = new SimpleInventory(1, EnvironmentalAccumulatorConfig._instance.getNamedId(), 64);
    private IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe;

    public TileEnvironmentalAccumulator() {
        if (MinecraftHelpers.isClientSide()) {
            this.setBeamInnerColor(this.getInnerColorByState(this.state));
            this.setBeamOuterColor(this.getOuterColorByState(this.state));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private Vector4f getInnerColorByState(int state) {
        if (state == 1) {
            return new Vector4f(0.48046875f, 0.29296875f, 0.1171875f, 0.05f);
        }
        if (state == 0) {
            return new Vector4f(0.48046875f, 0.29296875f, 0.1171875f, 0.13f);
        }
        return new Vector4f(0.0f, 0.0f, 0.0f, 0.13f);
    }

    @SideOnly(value=Side.CLIENT)
    private Vector4f getOuterColorByState(int state) {
        if (state == 2) {
            return new Vector4f(0.0f, 0.0f, 0.0f, 0.13f);
        }
        return new Vector4f(0.30078125f, 0.1875f, 0.08203125f, 0.13f);
    }

    public int getMaxCooldownTick() {
        EnvironmentalAccumulatorRecipeProperties result;
        EnvironmentalAccumulatorRecipeProperties environmentalAccumulatorRecipeProperties = result = this.recipe == null ? null : this.recipe.getProperties();
        if (result == null) {
            return EnvironmentalAccumulatorConfig.defaultTickCooldown;
        }
        return result.getCooldownTime();
    }

    @SideOnly(value=Side.CLIENT)
    public float getMovingItemY() {
        if (this.state == 1) {
            return 1.0f + (float)(this.getItemMoveDuration() - this.tick) * this.getItemMoveSpeed();
        }
        return -1.0f;
    }

    public IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> getRecipe() {
        return this.recipe;
    }

    private int getItemMoveDuration() {
        if (this.recipe == null) {
            return EnvironmentalAccumulatorConfig.defaultProcessItemTickCount;
        }
        return this.recipe.getProperties().getDuration();
    }

    private float getItemMoveSpeed() {
        if (this.recipe == null) {
            return (float)EnvironmentalAccumulatorConfig.defaultProcessItemSpeed;
        }
        return (float)this.recipe.getProperties().getProcessingSpeed();
    }

    @Override
    public void updateTileEntity() {
        super.updateTileEntity();
        if (this.tick > 0) {
            --this.tick;
        }
        if (this.state == 0) {
            this.updateEnvironmentalAccumulatorIdle();
        } else if (this.state == 1) {
            if (this.field_145850_b.field_72995_K) {
                this.showWaterBeams();
                if (this.tick > 50) {
                    this.showAccumulatingParticles();
                }
            }
            if (this.tick == 0) {
                this.dropItemStack();
                this.activateFinishedProcessingItemState();
            }
        } else if (this.state == 3) {
            if (this.tick == 0) {
                this.activateCooldownState();
                this.func_70298_a(0, this.func_70297_j_());
            }
        } else if (this.state == 2) {
            this.degradationExecutor.runRandomEffect(this.field_145850_b.field_72995_K);
            if (this.tick == 0) {
                this.activateIdleState();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void showWaterBeams() {
        Random random = this.field_145850_b.field_73012_v;
        Location target = new Location(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (int j = 0; j < waterOffsets.length; ++j) {
            ILocation offset = waterOffsets[j];
            ILocation location = target.add(offset);
            double x = (double)location.getCoordinates()[0] + 0.5;
            double y = (double)location.getCoordinates()[1] + 0.5;
            double z = (double)location.getCoordinates()[2] + 0.5;
            float rotationYaw = (float)LocationHelpers.getYaw(location, target);
            float rotationPitch = (float)LocationHelpers.getPitch(location, target);
            for (int i = 0; i < random.nextInt(2); ++i) {
                double particleX = x - 0.2 + random.nextDouble() * 0.4;
                double particleY = y - 0.2 + random.nextDouble() * 0.4;
                double particleZ = z - 0.2 + random.nextDouble() * 0.4;
                double speed = 2.0;
                double particleMotionX = (double)(MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                double particleMotionY = (double)MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * speed * 5.0;
                double particleMotionZ = (double)(MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new ExtendedEntityBubbleFX(this.field_145850_b, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ, 0.02));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void showAccumulatingParticles() {
        TileEnvironmentalAccumulator.showAccumulatingParticles(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 25.0);
    }

    @SideOnly(value=Side.CLIENT)
    public static void showAccumulatingParticles(World world, double centerX, double centerY, double centerZ, double spread) {
        Random rand = world.field_73012_v;
        for (int j = 0; j < rand.nextInt(20); ++j) {
            float scale = 0.6f - rand.nextFloat() * 0.4f;
            float red = rand.nextFloat() * 0.1f + 0.2f;
            float green = rand.nextFloat() * 0.1f + 0.3f;
            float blue = rand.nextFloat() * 0.1f + 0.2f;
            float ageMultiplier = 60.0f;
            double motionX = spread - rand.nextDouble() * 2.0 * spread;
            double motionY = spread - rand.nextDouble() * 2.0 * spread;
            double motionZ = spread - rand.nextDouble() * 2.0 * spread;
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntityTargettedBlurFX(world, scale, motionX, motionY, motionZ, red, green, blue, ageMultiplier, centerX, centerY, centerZ));
        }
    }

    private void updateEnvironmentalAccumulatorIdle() {
        List entityItems = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)((double)this.field_145848_d + 0.0), (double)this.field_145849_e, (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 2.0), (double)((double)this.field_145849_e + 1.0)));
        for (IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe : EnvironmentalAccumulator.getInstance().getRecipeRegistry().allRecipes()) {
            EnvironmentalAccumulatorRecipeComponent input = recipe.getInput();
            ItemStack recipeStack = input.getItemStack();
            WeatherType weatherType = input.getWeatherType();
            for (Object obj : entityItems) {
                EntityItem entityItem = (EntityItem)obj;
                ItemStack stack = entityItem.func_92059_d();
                if (recipeStack.func_77973_b() != stack.func_77973_b() || recipeStack.func_77960_j() != stack.func_77960_j() || recipeStack.field_77994_a > stack.field_77994_a || weatherType != null && !weatherType.isActive(this.field_145850_b)) continue;
                this.func_70299_a(0, stack.func_77946_l());
                this.recipe = recipe;
                if (!this.field_145850_b.field_72995_K) {
                    this.decreaseStackSize(entityItem, recipeStack);
                }
                this.activateProcessingItemState();
                return;
            }
        }
    }

    private void decreaseStackSize(EntityItem entityItem, ItemStack stack) {
        entityItem.func_92059_d().field_77994_a -= stack.field_77994_a;
        if (entityItem.func_92059_d().field_77994_a == 0) {
            entityItem.func_70106_y();
        }
    }

    private void dropItemStack() {
        if (!this.field_145850_b.field_72995_K) {
            EntityItem entity = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d + WEATHER_CONTAINER_SPAWN_HEIGHT, (double)this.field_145849_e);
            if (this.recipe == null) {
                entity.func_92058_a(this.func_70301_a(0));
            } else {
                WeatherType weatherResult;
                entity.func_92058_a(this.recipe.getProperties().getResultOverride().getResult((IBlockAccess)this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.recipe.getOutput().getConditionalItemStack(this.func_70301_a(0))));
                WeatherType weatherSource = this.recipe.getInput().getWeatherType();
                if (weatherSource != null) {
                    weatherSource.deactivate(this.field_145850_b);
                }
                if ((weatherResult = this.recipe.getOutput().getWeatherType()) != null) {
                    weatherResult.activate(this.field_145850_b);
                }
            }
            this.field_145850_b.func_72838_d((Entity)entity);
        }
    }

    private void activateIdleState() {
        this.tick = 0;
        this.state = 0;
        if (!this.field_145850_b.field_72995_K) {
            this.sendUpdate();
        }
    }

    private void activateProcessingItemState() {
        this.tick = this.recipe == null ? EnvironmentalAccumulatorConfig.defaultProcessItemTickCount : this.recipe.getProperties().getDuration();
        this.state = 1;
        if (!this.field_145850_b.field_72995_K) {
            this.sendUpdate();
        }
    }

    private void activateFinishedProcessingItemState() {
        this.tick = 1;
        this.state = 3;
        if (!this.field_145850_b.field_72995_K) {
            this.sendUpdate();
        }
    }

    private void activateCooldownState() {
        ++this.degradation;
        this.degradationExecutor.setTickInterval(100 / this.degradation);
        this.tick = this.getMaxCooldownTick();
        this.state = 2;
        if (!this.field_145850_b.field_72995_K) {
            this.sendUpdate();
        }
    }

    @Override
    public void onUpdateReceived() {
        if (this.field_145850_b.field_72995_K && this.state == 3) {
            IEAProcessingFinishedEffect effect;
            IEAProcessingFinishedEffect iEAProcessingFinishedEffect = effect = this.recipe == null ? null : this.recipe.getProperties().getFinishedProcessingEffect();
            if (effect == null) {
                this.field_145850_b.func_72926_e(2002, Math.round(this.field_145851_c), (int)Math.round((double)this.field_145848_d + WEATHER_CONTAINER_SPAWN_HEIGHT), Math.round(this.field_145849_e), 16428);
            } else {
                effect.executeEffect(this, this.recipe);
            }
        }
        this.setBeamColors(this.state);
    }

    public void setBeamColors(int state) {
        if (this.field_145850_b.field_72995_K) {
            this.setBeamInnerColor(this.getInnerColorByState(state));
            this.setBeamOuterColor(this.getOuterColorByState(state));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.degradation = compound.func_74762_e("degradation");
        this.tick = compound.func_74762_e("tick");
        this.state = compound.func_74762_e("state");
        String recipeId = compound.func_74779_i("recipe");
        if (recipeId != null) {
            this.recipe = EnvironmentalAccumulator.getInstance().getRecipeRegistry().findRecipeByNamedId(recipeId);
        }
        this.degradationExecutor.readFromNBT(compound);
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        String recipeId;
        super.func_145841_b(compound);
        compound.func_74768_a("degradation", this.degradation);
        compound.func_74768_a("tick", this.tick);
        compound.func_74768_a("state", this.state);
        String string = recipeId = this.recipe == null ? null : this.recipe.getNamedId();
        if (recipeId != null) {
            compound.func_74778_a("recipe", recipeId);
        }
        this.degradationExecutor.writeToNBT(compound);
    }

    public float func_110138_aP() {
        if (this.state == 1) {
            return this.getItemMoveDuration();
        }
        if (this.state == 3) {
            return 0.0f;
        }
        return this.getMaxCooldownTick();
    }

    public float func_110143_aJ() {
        if (this.state == 1) {
            return this.tick;
        }
        if (this.state == 2) {
            return this.getMaxCooldownTick() - this.tick;
        }
        return this.getMaxCooldownTick();
    }

    public IChatComponent func_145748_c_() {
        String message = L10NHelpers.localize("chat.bossDisplay.charge", L10NHelpers.localize(EnvironmentalAccumulator.getInstance().func_149739_a() + ".name"));
        return new ChatComponentText(message);
    }

    @Override
    public ILocation getLocation() {
        if (this.location == null) {
            this.location = new Location(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.location;
    }

    @Override
    public int getRadius() {
        return 5 + this.degradation / 10;
    }

    @Override
    public List<Entity> getAreaEntities() {
        return EntityHelpers.getEntitiesInArea(this.getWorld(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getRadius());
    }

    @Override
    public double getDegradation() {
        return this.degradation;
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        if (i >= this.func_70302_i_() || i < 0) {
            return null;
        }
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return this.inventory.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }
}

