/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity;

import com.google.common.collect.Lists;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.ILocation;
import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.block.EnvironmentalAccumulator;
import evilcraft.block.SanguinaryEnvironmentalAccumulator;
import evilcraft.client.particle.EntityBloodBubbleFX;
import evilcraft.core.algorithm.Location;
import evilcraft.core.algorithm.SingleCache;
import evilcraft.core.fluid.SingleUseTank;
import evilcraft.core.fluid.VirtualTank;
import evilcraft.core.helper.LocationHelpers;
import evilcraft.core.helper.WorldHelpers;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import evilcraft.core.tileentity.tickaction.ITickAction;
import evilcraft.core.tileentity.tickaction.TickComponent;
import evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import evilcraft.core.tileentity.upgrade.Upgrades;
import evilcraft.core.weather.WeatherType;
import evilcraft.fluid.Blood;
import evilcraft.tileentity.TileEnvironmentalAccumulator;
import evilcraft.tileentity.TileWorking;
import evilcraft.tileentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class TileSanguinaryEnvironmentalAccumulator
extends TileWorking<TileSanguinaryEnvironmentalAccumulator, MutableInt>
implements VirtualTank.ITankProvider {
    public static final int SLOTS = 2;
    public static final int SLOT_ACCUMULATE = 0;
    public static final int SLOT_ACCUMULATE_RESULT = 1;
    public static final Fluid ACCEPTED_FLUID = Blood.getInstance();
    private static final int TANK_CHECK_TICK_OFFSET = 60;
    private int accumulateTicker;
    private SingleCache<Triple<ItemStack, FluidStack, WeatherType>, IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties>> recipeCache;
    private VirtualTank virtualTank;
    private boolean forceLoadTanks;
    private List<ILocation> invalidLocations = Lists.newArrayList();
    private static final Map<Class<?>, ITickAction<TileSanguinaryEnvironmentalAccumulator>> ACCUMULATE_TICK_ACTIONS = new LinkedHashMap();
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    private static final ILocation[] tankOffsets;

    public TileSanguinaryEnvironmentalAccumulator() {
        super(2, SanguinaryEnvironmentalAccumulator.getInstance().func_149732_F(), 0, "", ACCEPTED_FLUID);
        this.accumulateTicker = this.addTicker(new TickComponent<TileSanguinaryEnvironmentalAccumulator, ITickAction<TileSanguinaryEnvironmentalAccumulator>>(this, ACCUMULATE_TICK_ACTIONS, 0));
        LinkedList<Integer> inSlots = new LinkedList<Integer>();
        inSlots.add(0);
        LinkedList<Integer> outSlots = new LinkedList<Integer>();
        outSlots.add(1);
        this.addSlotsToSide(ForgeDirection.EAST, inSlots);
        this.addSlotsToSide(ForgeDirection.UP, inSlots);
        this.addSlotsToSide(ForgeDirection.NORTH, inSlots);
        this.addSlotsToSide(ForgeDirection.DOWN, outSlots);
        this.addSlotsToSide(ForgeDirection.SOUTH, outSlots);
        this.addSlotsToSide(ForgeDirection.WEST, outSlots);
        this.upgradeBehaviour.put(UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileSanguinaryEnvironmentalAccumulator, MutableInt>(2.0){

            @Override
            public void applyUpgrade(TileSanguinaryEnvironmentalAccumulator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.upgradeBehaviour.put(UPGRADE_SPEED, new UpgradeBehaviour<TileSanguinaryEnvironmentalAccumulator, MutableInt>(1.0){

            @Override
            public void applyUpgrade(TileSanguinaryEnvironmentalAccumulator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.recipeCache = new SingleCache<Triple<ItemStack, FluidStack, WeatherType>, IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties>>(new SingleCache.ICacheUpdater<Triple<ItemStack, FluidStack, WeatherType>, IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties>>(){

            @Override
            public IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> getNewValue(Triple<ItemStack, FluidStack, WeatherType> key) {
                EnvironmentalAccumulatorRecipeComponent recipeInput = new EnvironmentalAccumulatorRecipeComponent((ItemStack)key.getLeft(), (WeatherType)key.getRight());
                for (IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe : EnvironmentalAccumulator.getInstance().getRecipeRegistry().findRecipesByInput(recipeInput)) {
                    if (!recipe.getInput().getWeatherType().isActive(TileSanguinaryEnvironmentalAccumulator.this.field_145850_b)) continue;
                    return recipe;
                }
                return null;
            }

            @Override
            public boolean isKeyEqual(Triple<ItemStack, FluidStack, WeatherType> cacheKey, Triple<ItemStack, FluidStack, WeatherType> newKey) {
                return cacheKey == null || newKey == null || ItemStack.func_77989_b((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.areFluidStackTagsEqual((FluidStack)((FluidStack)cacheKey.getMiddle()), (FluidStack)((FluidStack)newKey.getMiddle())) && cacheKey.getRight() == newKey.getRight();
            }
        });
        this.virtualTank = new VirtualTank(this, true);
        this.forceLoadTanks = true;
    }

    @Override
    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new SingleUseTank("noTank", 0, this);
    }

    public IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> getRecipe(ItemStack itemStack) {
        return this.recipeCache.get((Triple<ItemStack, FluidStack, WeatherType>)new ImmutableTriple((Object)(itemStack == null ? null : itemStack.func_77946_l()), (Object)(this.getTank().getFluid() == null ? null : this.getTank().getFluid().copy()), (Object)WeatherType.getActiveWeather(this.field_145850_b)));
    }

    @Override
    public void updateTileEntity() {
        super.updateTileEntity();
        if (this.field_145850_b.field_72995_K && this.isVisuallyWorking()) {
            this.showTankBeams();
            if (this.getRequiredWorkTicks() - (float)this.getWorkTick() > 50.0f) {
                this.showAccumulatingParticles();
            }
        } else if (this.field_145850_b.field_72995_K && !this.canWork()) {
            this.showMissingTanks();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void showAccumulatingParticles() {
        TileEnvironmentalAccumulator.showAccumulatingParticles(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 25.0);
    }

    @SideOnly(value=Side.CLIENT)
    protected void showTankBeams() {
        Random random = this.field_145850_b.field_73012_v;
        Location target = new Location(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (int j = 0; j < tankOffsets.length; ++j) {
            ILocation offset = tankOffsets[j];
            ILocation location = target.add(offset);
            double x = (double)location.getCoordinates()[0] + 0.5;
            double y = (double)location.getCoordinates()[1] + 0.5;
            double z = (double)location.getCoordinates()[2] + 0.5;
            float rotationYaw = (float)LocationHelpers.getYaw(location, target);
            float rotationPitch = (float)LocationHelpers.getPitch(location, target);
            for (int i = 0; i < 1 + random.nextInt(5); ++i) {
                double particleX = x - 0.2 + random.nextDouble() * 0.4;
                double particleY = y - 0.2 + random.nextDouble() * 0.4;
                double particleZ = z - 0.2 + random.nextDouble() * 0.4;
                double speed = 0.5;
                double particleMotionX = (double)(MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                double particleMotionY = (double)MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * -speed;
                double particleMotionZ = (double)(MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntityBloodBubbleFX(this.field_145850_b, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void showMissingTanks() {
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            Random random = this.field_145850_b.field_73012_v;
            for (ILocation location : this.invalidLocations) {
                double x = (double)location.getCoordinates()[0] + 0.5;
                double y = (double)location.getCoordinates()[1] + 0.5;
                double z = (double)location.getCoordinates()[2] + 0.5;
                for (int i = 0; i < 1 + random.nextInt(5); ++i) {
                    double particleX = x - 0.2 + random.nextDouble() * 0.4;
                    double particleY = y - 0.2 + random.nextDouble() * 0.4;
                    double particleZ = z - 0.2 + random.nextDouble() * 0.4;
                    FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntitySmokeFX(this.field_145850_b, particleX, particleY, particleZ, 0.0, 0.0, 0.0));
                }
            }
        }
    }

    @Override
    public boolean canConsume(ItemStack itemStack) {
        IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe = this.getRecipe(itemStack);
        return recipe != null;
    }

    public int getConsumeSlot() {
        return 0;
    }

    public int getProduceSlot() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return slot == 0 && this.canConsume(itemStack);
    }

    @Override
    public void onStateChanged() {
        this.sendUpdate();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean canWork() {
        if (!this.forceLoadTanks && this.invalidLocations != null && !WorldHelpers.efficientTick(this.field_145850_b, 60, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return this.invalidLocations.isEmpty();
        }
        this.forceLoadTanks = false;
        return this.getVirtualTankChildren() != null;
    }

    @Override
    protected int getWorkTicker() {
        return this.accumulateTicker;
    }

    public VirtualTank getVirtualTank() {
        return this.virtualTank;
    }

    @Override
    @Nullable
    public IFluidHandler[] getVirtualTankChildren() {
        IFluidHandler[] tanks = new IFluidHandler[tankOffsets.length];
        this.invalidLocations.clear();
        for (int i = 0; i < tankOffsets.length; ++i) {
            ILocation offset = tankOffsets[i];
            ILocation location = new Location(this.field_145851_c, this.field_145848_d, this.field_145849_e).add(offset);
            TileEntity tile = LocationHelpers.getTile((IBlockAccess)this.field_145850_b, location);
            if (tile == null || !(tile instanceof IFluidHandler)) {
                this.invalidLocations.add(location);
                continue;
            }
            IFluidHandler handler = (IFluidHandler)tile;
            FluidTankInfo[] info = handler.getTankInfo(VirtualTank.TARGETSIDE);
            if (info == null) {
                this.invalidLocations.add(location);
                continue;
            }
            boolean oneValid = false;
            for (FluidTankInfo tank : info) {
                if (tank.fluid == null || tank.fluid.getFluid() != ACCEPTED_FLUID) continue;
                oneValid = true;
                break;
            }
            if (!oneValid) {
                this.invalidLocations.add(location);
            }
            tanks[i] = handler;
        }
        if (!this.invalidLocations.isEmpty()) {
            return null;
        }
        return tanks;
    }

    public List<ILocation> getInvalidLocations() {
        return this.invalidLocations;
    }

    static {
        ACCUMULATE_TICK_ACTIONS.put(Item.class, new AccumulateItemTickAction());
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
        tankOffsets = new ILocation[]{new Location(-3, 0, -1), new Location(-3, 0, 1), new Location(3, 0, -1), new Location(3, 0, 1), new Location(-1, 0, -3), new Location(-1, 0, 3), new Location(1, 0, -3), new Location(1, 0, 3)};
    }
}

