/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity;

import evilcraft.api.ILocation;
import evilcraft.block.BloodStainedBlock;
import evilcraft.block.PurifierConfig;
import evilcraft.block.SanguinaryPedestalConfig;
import evilcraft.core.algorithm.Location;
import evilcraft.core.algorithm.RegionIterator;
import evilcraft.core.helper.LocationHelpers;
import evilcraft.core.tileentity.TankInventoryTileEntity;
import evilcraft.fluid.Blood;
import evilcraft.network.PacketHandler;
import evilcraft.network.packet.SanguinaryPedestalBlockReplacePacket;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileSanguinaryPedestal
extends TankInventoryTileEntity {
    public static final Fluid FLUID = Blood.getInstance();
    private static final int MB_RATE = 100;
    private static final int TANK_BUCKETS = 10;
    private static final int OFFSET = 2;
    private static final int OFFSET_EFFICIENCY = 4;
    private static final int ACTIONS_PER_TICK_EFFICIENCY = 5;
    private RegionIterator regionIterator;

    public TileSanguinaryPedestal() {
        super(0, PurifierConfig._instance.getNamedId(), 1, 10000, SanguinaryPedestalConfig._instance.getNamedId() + "tank", FLUID);
    }

    public void fillWithPotentialBonus(FluidStack fluidStack) {
        if (this.hasEfficiency() && fluidStack != null) {
            fluidStack.amount = (int)((double)fluidStack.amount * SanguinaryPedestalConfig.efficiencyBoost);
        }
        this.fill(fluidStack, true);
    }

    protected void afterBlockReplace(World world, ILocation location, Block block, int amount) {
        if (!this.getTank().isFull()) {
            this.fillWithPotentialBonus(new FluidStack(FLUID, amount));
        }
        PacketHandler.sendToServer(new SanguinaryPedestalBlockReplacePacket(location, block));
    }

    protected boolean hasEfficiency() {
        return this.func_145832_p() == 1;
    }

    @Override
    public void updateTileEntity() {
        super.updateTileEntity();
        if (!this.func_145831_w().field_72995_K) {
            int actions;
            int n = actions = this.hasEfficiency() ? 5 : 1;
            while (!this.getTank().isFull() && actions > 0) {
                ILocation location = this.getNextLocation();
                Block block = LocationHelpers.getBlock(this.func_145831_w(), location);
                if (block == BloodStainedBlock.getInstance()) {
                    BloodStainedBlock.UnstainResult result = BloodStainedBlock.getInstance().unstainBlock(this.func_145831_w(), location, this.getTank().getCapacity() - this.getTank().getFluidAmount());
                    if (result.amount > 0) {
                        this.afterBlockReplace(this.func_145831_w(), location, result.block, result.amount);
                    }
                }
                --actions;
            }
            if (!this.getTank().isEmpty()) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
                    if (this.getTank().isEmpty() || !(tile instanceof IFluidHandler)) continue;
                    IFluidHandler handler = (IFluidHandler)tile;
                    FluidStack fluidStack = new FluidStack(this.getTank().getFluidType(), Math.min(100, this.getTank().getFluidAmount()));
                    if (!handler.canFill(direction.getOpposite(), this.getTank().getFluidType()) || handler.fill(direction.getOpposite(), fluidStack, false) <= 0) continue;
                    int filled = handler.fill(direction.getOpposite(), fluidStack, true);
                    this.drain(filled, true);
                }
            }
        }
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[0];
    }

    private ILocation getNextLocation() {
        if (this.regionIterator == null) {
            this.regionIterator = new RegionIterator(new Location(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.hasEfficiency() ? 4 : 2, true);
        }
        return this.regionIterator.next();
    }
}

