/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity;

import evilcraft.core.tileentity.TankInventoryTileEntity;
import evilcraft.core.tileentity.WorkingTileEntity;
import evilcraft.core.tileentity.upgrade.Upgrades;
import evilcraft.item.Promise;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public abstract class TileWorking<T extends TankInventoryTileEntity, O>
extends WorkingTileEntity<T, O> {
    public static final Item UPGRADE_ITEM = Promise.getInstance();
    private int currentTier = -1;

    public TileWorking(int inventorySize, String inventoryName, int tankSize, String tankName, Fluid acceptedFluid) {
        super(inventorySize, inventoryName, tankSize, tankName, acceptedFluid);
    }

    @Override
    public Upgrades.Upgrade getUpgradeType(ItemStack itemStack) {
        if (itemStack.func_77973_b() == UPGRADE_ITEM) {
            Upgrades.Upgrade upgrade = Promise.getInstance().getUpgrade(itemStack);
            if (this.getUpgrades().contains(upgrade)) {
                return upgrade;
            }
        }
        return null;
    }

    @Override
    public int getUpgradeLevel(ItemStack itemStack) {
        return itemStack.field_77994_a;
    }

    @Override
    public boolean onUpgradeSlotChanged(int slotId, ItemStack oldItemStack, ItemStack itemStack) {
        if (super.onUpgradeSlotChanged(slotId, oldItemStack, itemStack)) {
            this.resetTier();
            if (!this.field_145850_b.field_72995_K) {
                this.getTank().setCapacity(TileWorking.getTankTierMultiplier(this.getTier()) * this.tankSize);
            }
            this.sendUpdate();
            return true;
        }
        return false;
    }

    public static int getTankTierMultiplier(int tier) {
        return 1 << tier * 2;
    }

    protected void resetTier() {
        this.currentTier = -1;
    }

    public int getTier() {
        if (this.currentTier == -1) {
            for (int i = this.getBasicInventorySize(); i < this.getBasicInventorySize() + 4; ++i) {
                ItemStack itemStack = this.func_70301_a(i);
                if (!Promise.getInstance().isTierUpgrade(itemStack)) continue;
                this.currentTier = Promise.getInstance().getUpgrade(itemStack).getTier();
            }
            if (this.currentTier == -1) {
                this.currentTier = 0;
            }
        }
        return this.currentTier;
    }

    protected int getRequiredTierForSlot(int slotId) {
        if (!this.isUpgradeSlot(slotId)) {
            return 0;
        }
        return slotId - this.getBasicInventorySize();
    }

    protected boolean areUpgradeSlotsValidForTier(int tier) {
        for (int i = this.getBasicInventorySize() + tier + 1; i < this.getBasicInventorySize() + 4; ++i) {
            if (this.func_70301_a(i) == null || Promise.getInstance().isTierUpgrade(this.func_70301_a(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isUpgradeSlotEnabled(int slotId) {
        return this.getRequiredTierForSlot(slotId) <= this.getTier();
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return super.func_102007_a(slot, itemStack, side) && this.canInsertItem(slot, itemStack);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return super.func_102008_b(slot, itemStack, side) && this.canExtractItem(slot, itemStack, null);
    }

    public boolean canInsertItem(int slot, ItemStack itemStack) {
        if (!this.isUpgradeSlot(slot)) {
            return true;
        }
        if (!this.getUpgrades().contains(Promise.getInstance().getUpgrade(itemStack))) {
            return false;
        }
        if (Promise.getInstance().isTierUpgrade(itemStack) && Promise.getInstance().isTierUpgrade(this.func_70301_a(slot))) {
            return true;
        }
        if (Promise.getInstance().isTierUpgrade(this.func_70301_a(slot))) {
            return this.areUpgradeSlotsValidForTier(0);
        }
        if (Promise.getInstance().isTierUpgrade(itemStack)) {
            return this.getTier() == 0 && this.getRequiredTierForSlot(slot) <= Promise.getInstance().getUpgrade(itemStack).getTier();
        }
        return this.isUpgradeSlotEnabled(slot);
    }

    public boolean canExtractItem(int slot, ItemStack itemStack, ItemStack replaceItem) {
        if (!this.isUpgradeSlot(slot)) {
            return true;
        }
        if (Promise.getInstance().isTierUpgrade(itemStack) && Promise.getInstance().isTierUpgrade(replaceItem)) {
            int currentTier;
            int newTier = Promise.getInstance().getUpgrade(replaceItem).getTier();
            return newTier >= (currentTier = Promise.getInstance().getUpgrade(itemStack).getTier()) || this.areUpgradeSlotsValidForTier(newTier);
        }
        if (Promise.getInstance().isTierUpgrade(itemStack)) {
            return this.areUpgradeSlotsValidForTier(0);
        }
        return true;
    }
}

