/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity.tickaction.bloodchest;

import evilcraft.api.RegistryManager;
import evilcraft.api.tileentity.bloodchest.IBloodChestRepairActionRegistry;
import evilcraft.block.ColossalBloodChestConfig;
import evilcraft.core.helper.MathHelpers;
import evilcraft.core.tileentity.tickaction.ITickAction;
import evilcraft.core.tileentity.upgrade.UpgradeSensitiveEvent;
import evilcraft.core.tileentity.upgrade.Upgrades;
import evilcraft.tileentity.TileColossalBloodChest;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableFloat;

public class BulkRepairItemTickAction
implements ITickAction<TileColossalBloodChest> {
    @Override
    public boolean canTick(TileColossalBloodChest tile, ItemStack itemStack, int slot, int tick) {
        return tile.canWork() && !tile.getTank().isEmpty() && itemStack != null;
    }

    private void drainTank(TileColossalBloodChest tile, float usageMultiplier, int tick) {
        tile.getTank().drain(this.getRequiredFluid(tile, usageMultiplier, tick), true);
    }

    protected int getRequiredFluid(TileColossalBloodChest tile, float usageMultiplier, int tick) {
        MutableFloat drain = new MutableFloat((float)ColossalBloodChestConfig.baseMBPerDamage * usageMultiplier * (float)(210 - tile.getEfficiency()) / 200.0f);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableFloat>(drain, TileColossalBloodChest.UPGRADEEVENT_BLOODUSAGE));
        return MathHelpers.factorToBursts(drain.getValue().floatValue(), (int)tile.func_145831_w().func_72820_D() + tick % 100);
    }

    @Override
    public void onTick(TileColossalBloodChest tile, ItemStack itemStack, int slot, int tick) {
        IBloodChestRepairActionRegistry actions;
        int actionID;
        if ((float)tick >= this.getRequiredTicks(tile, slot, tick) && !tile.getTank().isEmpty() && itemStack != null && (actionID = (actions = RegistryManager.getRegistry(IBloodChestRepairActionRegistry.class)).canRepair(itemStack, tick)) > -1) {
            float simulateMultiplier = actions.repair(itemStack, tile.func_145831_w().field_73012_v, actionID, false, true);
            if ((float)tile.getTank().getFluidAmount() >= (float)this.getRequiredFluid(tile, simulateMultiplier, tick) * simulateMultiplier) {
                Boolean slotHistory = tile.getSlotTickHistory().get(slot);
                if (slotHistory == null || !slotHistory.booleanValue()) {
                    tile.setEfficiency(Math.min(tile.getEfficiency() + 1, 200));
                    tile.getSlotTickHistory().put(slot, true);
                }
                float multiplier = actions.repair(itemStack, tile.func_145831_w().field_73012_v, actionID, true, true);
                this.drainTank(tile, multiplier, tick);
            }
        }
    }

    @Override
    public float getRequiredTicks(TileColossalBloodChest tile, int slot, int tick) {
        MutableFloat duration = new MutableFloat((float)ColossalBloodChestConfig.ticksPerDamage);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableFloat>(duration, TileColossalBloodChest.UPGRADEEVENT_SPEED));
        return duration.getValue().floatValue();
    }
}

