/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity.tickaction.spiritreanimator;

import evilcraft.block.SpiritReanimatorConfig;
import evilcraft.core.helper.InventoryHelpers;
import evilcraft.core.helper.MathHelpers;
import evilcraft.core.tileentity.tickaction.ITickAction;
import evilcraft.core.tileentity.upgrade.UpgradeSensitiveEvent;
import evilcraft.core.tileentity.upgrade.Upgrades;
import evilcraft.tileentity.TileSpiritFurnace;
import evilcraft.tileentity.TileSpiritReanimator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.mutable.MutableDouble;

public class ReanimateTickAction
implements ITickAction<TileSpiritReanimator> {
    @Override
    public boolean canTick(TileSpiritReanimator tile, ItemStack itemStack, int slot, int tick) {
        return tile.getTank().getFluidAmount() >= this.getRequiredMb(tile, tick) && tile.canWork();
    }

    protected ItemStack getCookStack(TileSpiritFurnace tile) {
        return tile.getInventory().func_70301_a(tile.getConsumeSlot());
    }

    @Override
    public void onTick(TileSpiritReanimator tile, ItemStack itemStack, int slot, int tick) {
        tile.getTank().drain(this.getRequiredMb(tile, tick), true);
        if ((float)tick >= this.getRequiredTicks(tile, slot, tick)) {
            ItemStack eggStack;
            int entityID = tile.getEntityID();
            if (SpiritReanimatorConfig.clearBoxContents) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            if (entityID > -1 && this.addToProduceSlot(tile, eggStack = new ItemStack((Item)Item.field_150901_e.func_82594_a("spawn_egg"), 1, entityID))) {
                tile.getInventory().func_70298_a(2, 1);
            }
        }
    }

    protected int getRequiredMb(TileSpiritReanimator tile, int tick) {
        MutableDouble drain = new MutableDouble((double)SpiritReanimatorConfig.mBPerTick);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(drain, TileSpiritReanimator.UPGRADEEVENT_BLOODUSAGE));
        return MathHelpers.factorToBursts(drain.getValue(), tick);
    }

    @Override
    public float getRequiredTicks(TileSpiritReanimator tile, int slot, int tick) {
        MutableDouble drain = new MutableDouble((double)SpiritReanimatorConfig.requiredTicks);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(drain, TileSpiritReanimator.UPGRADEEVENT_SPEED));
        return (int)drain.getValue().doubleValue();
    }

    public boolean addToProduceSlot(TileSpiritReanimator tile, ItemStack itemStack) {
        return InventoryHelpers.addToSlot(tile.getInventory(), 3, itemStack);
    }
}

