/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.world.gen;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import evilcraft.Configs;
import evilcraft.GeneralConfig;
import evilcraft.api.ILocation;
import evilcraft.block.EnvironmentalAccumulatorConfig;
import evilcraft.core.algorithm.Location;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.world.gen.nbt.DarkTempleData;
import evilcraft.world.gen.structure.DarkTempleStructure;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.lang3.tuple.Pair;

public class DarkTempleGenerator
implements IWorldGenerator {
    private static Map<Integer, DarkTempleData> darkTemples = Maps.newHashMap();
    private static final String DARK_TEMPLE_MAP_NAME = "DarkTemple";

    public DarkTempleGenerator() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static DarkTempleData getCachedData(World world) {
        DarkTempleData data = darkTemples.get(world.field_73011_w.field_76574_g);
        if (data == null) {
            data = DarkTempleGenerator.loadData(world);
            darkTemples.put(world.field_73011_w.field_76574_g, data);
        }
        return data;
    }

    private static DarkTempleData loadData(World world) {
        DarkTempleData data = (DarkTempleData)world.perWorldStorage.func_75742_a(DarkTempleData.class, DARK_TEMPLE_MAP_NAME);
        if (data == null) {
            data = new DarkTempleData(DARK_TEMPLE_MAP_NAME);
            world.perWorldStorage.func_75745_a(DARK_TEMPLE_MAP_NAME, (WorldSavedData)data);
        }
        return data;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!MinecraftHelpers.isClientSide()) {
            int id = event.world.field_73011_w.field_76574_g;
            darkTemples.remove(id);
            DarkTempleData data = DarkTempleGenerator.loadData(event.world);
            darkTemples.put(id, data);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!MinecraftHelpers.isClientSide()) {
            DarkTempleData data = DarkTempleGenerator.getCachedData(event.world);
            data.func_76186_a(true);
        }
    }

    public static boolean canGenerate(World world) {
        int id = world.field_73011_w.field_76574_g;
        for (int i = 0; i < GeneralConfig.darkTempleDimensions.length; ++i) {
            if (id != GeneralConfig.darkTempleDimensions[i]) continue;
            return true;
        }
        return false;
    }

    protected static boolean appliesAt(World world, int chunkX, int chunkZ) {
        if (world.func_72807_a(chunkX * 16, chunkZ * 16).func_150561_m() == BiomeGenBase.TempCategory.OCEAN) {
            return false;
        }
        int frequency = GeneralConfig.darkTempleFrequency;
        return ((long)(chunkX * chunkZ + chunkX - chunkZ) + world.func_72905_C()) % (long)frequency == 0L;
    }

    public static boolean hasTemple(World world, int chunkX, int chunkZ) {
        return DarkTempleGenerator.appliesAt(world, chunkX, chunkZ) && !DarkTempleGenerator.getCachedData(world).isFailed(chunkX, chunkZ);
    }

    @Nullable
    public static Pair<Integer, Integer> getClosest(World world, int chunkX, int chunkZ, int radius) {
        int x = 0;
        int z = 0;
        int dx = 0;
        int dz = -1;
        for (int r = 0; r < radius * radius; ++r) {
            if (-r / 2 <= x && x <= r / 2 && -r / 2 <= z && z <= r / 2 && DarkTempleGenerator.hasTemple(world, chunkX + x, chunkZ + z)) {
                return Pair.of((Object)(chunkX + x), (Object)(chunkZ + z));
            }
            if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                int t = dx;
                dx = -dz;
                dz = t;
            }
            x += dx;
            z += dz;
        }
        return null;
    }

    @Nullable
    public static Pair<Integer, Integer> getClosest(World world, int chunkX, int chunkZ) {
        return DarkTempleGenerator.getClosest(world, chunkX, chunkZ, Math.min(500, GeneralConfig.darkTempleFrequency));
    }

    @Nullable
    public static ILocation getClosestForCoords(World world, int x, int z) {
        Pair<Integer, Integer> closest = DarkTempleGenerator.getClosest(world, x / 16, z / 16);
        if (closest == null) {
            return null;
        }
        return new Location((Integer)closest.getLeft() * 16, 0, (Integer)closest.getRight() * 16);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (DarkTempleGenerator.canGenerate(world) && Configs.isEnabled(EnvironmentalAccumulatorConfig.class) && DarkTempleGenerator.appliesAt(world, chunkX, chunkZ)) {
            int x = chunkX * 16 + random.nextInt(16);
            int y = 0;
            int z = chunkZ * 16 + random.nextInt(16);
            if (!DarkTempleStructure.getInstance().generate(world, random, x, y, z)) {
                DarkTempleGenerator.getCachedData(world).addFailedLocation(chunkX, chunkZ);
            }
        }
    }
}

