/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block;

import com.bluepowermod.BluePower;
import com.bluepowermod.api.BPApi;
import com.bluepowermod.api.block.IAdvancedSilkyRemovable;
import com.bluepowermod.block.BlockBase;
import com.bluepowermod.client.render.RendererBlockBase;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.reference.GuiIDs;
import com.bluepowermod.tile.IBluePowered;
import com.bluepowermod.tile.IEjectAnimator;
import com.bluepowermod.tile.IRotatable;
import com.bluepowermod.tile.TileBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.misc.ForgeDirectionUtils;

public class BlockContainerBase
extends BlockBase
implements ITileEntityProvider,
IAdvancedSilkyRemovable {
    @SideOnly(value=Side.CLIENT)
    protected Map<String, IIcon> textures;
    private GuiIDs guiId = GuiIDs.INVALID;
    private Class<? extends TileBase> tileEntityClass;
    private boolean isRedstoneEmitter;
    private boolean isSilkyRemoving;

    public BlockContainerBase(Material material, Class<? extends TileBase> tileEntityClass) {
        super(material);
        this.field_149758_A = true;
        this.setTileEntityClass(tileEntityClass);
    }

    public BlockContainerBase setGuiId(GuiIDs guiId) {
        this.guiId = guiId;
        return this;
    }

    public BlockContainerBase setTileEntityClass(Class<? extends TileBase> tileEntityClass) {
        this.tileEntityClass = tileEntityClass;
        return this;
    }

    public BlockContainerBase emitsRedstone() {
        this.isRedstoneEmitter = true;
        return this;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        try {
            return this.getTileEntity().newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Class<? extends TileEntity> getTileEntity() {
        return this.tileEntityClass;
    }

    protected TileBase get(IBlockAccess w, int x, int y, int z) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileBase)) {
            return null;
        }
        return (TileBase)te;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileBase tileEntity;
        super.func_149695_a(world, x, y, z, block);
        if (!world.field_72995_K && (tileEntity = this.get((IBlockAccess)world, x, y, z)) != null) {
            tileEntity.onBlockNeighbourChanged();
        }
    }

    public boolean func_149744_f() {
        return this.isRedstoneEmitter;
    }

    public int func_149709_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        TileBase te = this.get(par1IBlockAccess, par2, par3, par4);
        if (te instanceof TileBase) {
            TileBase tileBase = te;
            return tileBase.getOutputtingRedstone();
        }
        return 0;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.func_70093_af() && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == BPItems.screwdriver) {
            return false;
        }
        if (player.func_70093_af()) {
            return false;
        }
        TileBase entity = this.get((IBlockAccess)world, x, y, z);
        if (entity == null || !(entity instanceof TileBase)) {
            return false;
        }
        if (this.getGuiID() != GuiIDs.INVALID) {
            if (!world.field_72995_K) {
                player.openGui((Object)BluePower.instance, this.getGuiID().ordinal(), world, x, y, z);
            }
            return true;
        }
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileBase tile;
        if (!this.isSilkyRemoving && (tile = this.get((IBlockAccess)world, x, y, z)) != null) {
            for (ItemStack stack : tile.getDrops()) {
                IOHelper.spawnItemInWorld(world, stack, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
        world.func_147475_p(x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack iStack) {
        BPApi.getInstance().loadSilkySettings(world, x, y, z, iStack);
        TileBase te = this.get((IBlockAccess)world, x, y, z);
        if (te instanceof IRotatable) {
            ((IRotatable)te).setFacingDirection(ForgeDirectionUtils.getDirectionFacing((EntityLivingBase)player, (boolean)this.canRotateVertical()).getOpposite());
        }
    }

    protected boolean canRotateVertical() {
        return true;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        TileBase te = this.get((IBlockAccess)worldObj, x, y, z);
        if (te instanceof IRotatable) {
            IRotatable rotatable = te;
            ForgeDirection dir = rotatable.getFacingDirection();
            if ((dir = dir.getRotation(axis)) != ForgeDirection.UP && dir != ForgeDirection.DOWN || this.canRotateVertical()) {
                rotatable.setFacingDirection(dir);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new HashMap<String, IIcon>();
        block0: for (RendererBlockBase.EnumFaceType faceType : RendererBlockBase.EnumFaceType.values()) {
            boolean ejecting = false;
            boolean powered = false;
            while (true) {
                String iconName;
                if (!this.textures.containsKey(iconName = this.getIconName(faceType, ejecting, powered))) {
                    this.textures.put(iconName, iconRegister.func_94245_a(iconName));
                }
                boolean bl = powered = !powered;
                if (powered && IBluePowered.class.isAssignableFrom(this.getTileEntity())) continue;
                boolean bl2 = ejecting = !ejecting;
                if (!ejecting || !IEjectAnimator.class.isAssignableFrom(this.getTileEntity())) continue block0;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(RendererBlockBase.EnumFaceType faceType, boolean ejecting, boolean powered) {
        return this.textures.get(this.getIconName(faceType, ejecting, powered));
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getIcon(RendererBlockBase.EnumFaceType faceType, boolean ejecting, boolean powered, int side, TileEntity te) {
        return this.getIcon(faceType, ejecting, powered);
    }

    public Block func_149663_c(String name) {
        super.func_149663_c(name);
        this.field_149768_d = "bluepower:machines/" + name;
        return this;
    }

    protected String getIconName(RendererBlockBase.EnumFaceType faceType, boolean ejecting, boolean powered) {
        String iconName = this.field_149768_d + "_" + faceType.toString().toLowerCase();
        if (faceType == RendererBlockBase.EnumFaceType.SIDE && ejecting) {
            iconName = iconName + "_active";
        }
        return iconName;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (this.textures == null) {
            return super.func_149673_e(world, x, y, z, side);
        }
        TileBase te = this.get(world, x, y, z);
        RendererBlockBase.EnumFaceType faceType = RendererBlockBase.EnumFaceType.SIDE;
        boolean powered = false;
        boolean ejecting = false;
        if (te instanceof IRotatable) {
            ForgeDirection rotation = ((IRotatable)te).getFacingDirection();
            if (rotation.ordinal() == side) {
                faceType = RendererBlockBase.EnumFaceType.FRONT;
            }
            if (rotation.getOpposite().ordinal() == side) {
                faceType = RendererBlockBase.EnumFaceType.BACK;
            }
        }
        if (te instanceof IBluePowered) {
            powered = ((IBluePowered)((Object)te)).isPowered();
        }
        if (te instanceof IEjectAnimator) {
            ejecting = ((IEjectAnimator)((Object)te)).isEjecting();
        }
        return this.getIcon(faceType, ejecting, powered, side, te);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (this.textures == null) {
            return super.func_149691_a(side, meta);
        }
        return this.getIcon(RendererBlockBase.EnumFaceType.values()[side == 0 ? 2 : (side == 1 ? 1 : 0)], false, false);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return RendererBlockBase.RENDER_ID;
    }

    public GuiIDs getGuiID() {
        return this.guiId;
    }

    @Override
    public boolean preSilkyRemoval(World world, int x, int y, int z) {
        this.isSilkyRemoving = true;
        return true;
    }

    @Override
    public void postSilkyRemoval(World world, int x, int y, int z) {
        this.isSilkyRemoving = false;
    }

    @Override
    public boolean writeSilkyData(World world, int x, int y, int z, NBTTagCompound tag) {
        world.func_147438_o(x, y, z).func_145841_b(tag);
        return false;
    }

    @Override
    public void readSilkyData(World world, int x, int y, int z, NBTTagCompound tag) {
        world.func_147438_o(x, y, z).func_145839_a(tag);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return ((TileBase)world.func_147438_o(x, y, z)).canConnectRedstone();
    }
}

