/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.compat.cc;

import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnectionCache;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.compat.cc.CCUtils;
import com.bluepowermod.redstone.BundledConnectionCache;
import com.bluepowermod.redstone.RedstoneApi;
import dan200.computercraft.api.ComputerCraftAPI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.vec.Vec3i;

public class BundledDeviceCCComputer
implements IBundledDevice {
    private static List<BundledDeviceCCComputer> list = new ArrayList<BundledDeviceCCComputer>();
    private Vec3i loc;
    private byte[][] curPow = new byte[6][16];
    private BundledConnectionCache connections = RedstoneApi.getInstance().createBundledConnectionCache(this);

    public static BundledDeviceCCComputer getDeviceAt(World world, int x, int y, int z) {
        Vec3i loc = new Vec3i(x, y, z, world);
        for (BundledDeviceCCComputer c : list) {
            if (!c.loc.equals((Object)loc)) continue;
            return c;
        }
        BundledDeviceCCComputer c = new BundledDeviceCCComputer(loc);
        list.add(c);
        return c;
    }

    public BundledDeviceCCComputer(Vec3i loc) {
        this.loc = loc;
    }

    public World getWorld() {
        return this.loc.getWorld();
    }

    public int getX() {
        return this.loc.getX();
    }

    public int getY() {
        return this.loc.getY();
    }

    public int getZ() {
        return this.loc.getZ();
    }

    @Override
    public boolean canConnect(ForgeDirection side, IBundledDevice dev, ConnectionType type) {
        return type == ConnectionType.STRAIGHT || side != ForgeDirection.UNKNOWN;
    }

    @Override
    public IConnectionCache<? extends IBundledDevice> getBundledConnectionCache() {
        return this.connections;
    }

    @Override
    public byte[] getBundledOutput(ForgeDirection side) {
        int out = ComputerCraftAPI.getBundledRedstoneOutput((World)this.getWorld(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), (int)side.ordinal());
        if (out < 0) {
            return new byte[16];
        }
        return CCUtils.unpackDigital(out);
    }

    @Override
    public void setBundledPower(ForgeDirection side, byte[] power) {
        if (side == ForgeDirection.UNKNOWN) {
            return;
        }
        this.curPow[side.ordinal()] = power;
    }

    @Override
    public byte[] getBundledPower(ForgeDirection side) {
        return this.getBundledOutput(side);
    }

    @Override
    public void onBundledUpdate() {
        this.getWorld().func_147460_e(this.getX(), this.getY(), this.getZ(), Blocks.field_150350_a);
    }

    public byte[] getCurPow(ForgeDirection side) {
        return this.curPow[side.ordinal()];
    }

    @Override
    public MinecraftColor getBundledColor(ForgeDirection side) {
        return MinecraftColor.NONE;
    }

    @Override
    public boolean isNormalFace(ForgeDirection side) {
        return true;
    }
}

