/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.compat.fmp;

import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.TMultiPart;
import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnectionCache;
import com.bluepowermod.api.misc.IFace;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.redstone.RedstoneApi;
import com.bluepowermod.redstone.RedstoneConnectionCache;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.helper.MathHelper;

public class FMPRedstoneDevice
implements IRedstoneDevice,
IFace {
    private TMultiPart part;
    private RedstoneConnectionCache connections = RedstoneApi.getInstance().createRedstoneConnectionCache(this);

    public FMPRedstoneDevice(TMultiPart part) {
        this.part = part;
    }

    public World getWorld() {
        return this.part.world();
    }

    public int getX() {
        return this.part.x();
    }

    public int getY() {
        return this.part.y();
    }

    public int getZ() {
        return this.part.z();
    }

    @Override
    public boolean canConnect(ForgeDirection side, IRedstoneDevice device, ConnectionType type) {
        if (type == ConnectionType.STRAIGHT || type == ConnectionType.CLOSED_CORNER) {
            if (side == ForgeDirection.UNKNOWN) {
                return false;
            }
            if (!(device instanceof IFace)) {
                return false;
            }
            return ((IRedstonePart)this.part).canConnectRedstone(side.ordinal());
        }
        return false;
    }

    @Override
    public IConnectionCache<? extends IRedstoneDevice> getRedstoneConnectionCache() {
        return this.connections;
    }

    @Override
    public byte getRedstonePower(ForgeDirection side) {
        IFaceRedstonePart p = (IFaceRedstonePart)this.part;
        if (this.part.tile() == null && this.part.world() == null) {
            return 0;
        }
        int pow = Math.max(p.weakPowerLevel(side.ordinal()), p.strongPowerLevel(side.ordinal()));
        return (byte)MathHelper.map((int)pow, (int)0, (int)15, (int)0, (int)255);
    }

    @Override
    public void setRedstonePower(ForgeDirection side, byte power) {
    }

    @Override
    public void onRedstoneUpdate() {
        if (this.part.tile() != null && this.part.world() != null) {
            this.part.onNeighborChanged();
        }
    }

    @Override
    public ForgeDirection getFace() {
        return ForgeDirection.getOrientation((int)((IFaceRedstonePart)this.part).getFace());
    }

    @Override
    public boolean isNormalFace(ForgeDirection side) {
        return false;
    }
}

