/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.container;

import com.bluepowermod.container.slot.SlotProjectTableCrafting;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.tile.tier1.TileProjectTable;
import cpw.mods.fml.common.Optional;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.util.ForgeDirection;

@ChestContainer
public class ContainerProjectTable
extends Container {
    public final IInventory craftResult = new InventoryCraftResult();
    private final TileProjectTable projectTable;
    private final InventoryCrafting craftingGrid;
    private int itemsCrafted;
    private boolean isRetrying = false;

    public ContainerProjectTable(InventoryPlayer invPlayer, TileProjectTable projectTable) {
        int j;
        int i;
        this.projectTable = projectTable;
        this.craftingGrid = projectTable.getCraftingGrid(this);
        this.func_75130_a((IInventory)this.craftingGrid);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftingGrid, j + i * 3, 34 + j * 18, 16 + i * 18));
            }
        }
        this.func_75146_a((Slot)new SlotProjectTableCrafting(projectTable, invPlayer.field_70458_d, (IInventory)this.craftingGrid, this.craftResult, 0, 127, 34));
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)projectTable, j + i * 9, 8 + j * 18, 79 + i * 18));
            }
        }
        this.bindPlayerInventory(invPlayer);
    }

    protected void bindPlayerInventory(InventoryPlayer invPlayer) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)invPlayer, j + i * 9 + 9, 8 + j * 18, 126 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.func_75146_a(new Slot((IInventory)invPlayer, j, 8 + j * 18, 184));
        }
    }

    public void func_75130_a(IInventory p_75130_1_) {
        if (this.craftingGrid != null) {
            this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.craftingGrid, this.projectTable.func_145831_w()));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.projectTable.func_70300_a(player);
    }

    protected void func_75133_b(int slot, int p_75133_2_, boolean p_75133_3_, EntityPlayer p_75133_4_) {
        ItemStack stackInSlot = ((Slot)this.field_75151_b.get(slot)).func_75211_c();
        this.itemsCrafted += stackInSlot.field_77994_a;
        this.isRetrying = true;
        if (slot != 9 || !this.isLastCraftingOperation() && this.itemsCrafted < stackInSlot.func_77976_d()) {
            this.func_75144_a(slot, p_75133_2_, 1, p_75133_4_);
        }
        this.isRetrying = false;
    }

    private boolean isLastCraftingOperation() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.craftingGrid.func_70301_a(i);
            if (stack == null || stack.field_77994_a != 1 || ContainerProjectTable.extractStackFromTable(this.projectTable, stack, true) != null || stack.func_77973_b().hasContainerItem(stack) && !stack.func_77973_b().func_77630_h(stack)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack extractStackFromTable(TileProjectTable table, ItemStack stack, boolean simulate) {
        return IOHelper.extract(table, ForgeDirection.UNKNOWN, stack, true, simulate);
    }

    public void clearCraftingGrid() {
        for (int i = 0; i < 9; ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!slot.func_75216_d()) continue;
            this.func_75135_a(slot.func_75211_c(), 10, 28, false);
            if (slot.func_75211_c().field_77994_a > 0) continue;
            slot.func_75215_d(null);
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int par2) {
        if (!this.isRetrying) {
            this.itemsCrafted = 0;
        }
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(par2);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (par2 < 9 ? !this.func_75135_a(itemstack1, 10, 28, false) : (par2 == 9 ? !this.func_75135_a(itemstack1, 28, 64, false) : (par2 < 28 ? !this.func_75135_a(itemstack1, 28, 64, false) : !this.func_75135_a(itemstack1, 10, 28, false)))) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a != itemstack.field_77994_a) {
                slot.func_82870_a(player, itemstack1);
            } else {
                return null;
            }
        }
        return itemstack;
    }

    @Optional.Method(modid="inventorytweaks")
    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> getSections() {
        int i;
        HashMap<ContainerSection, List<Slot>> sections = new HashMap<ContainerSection, List<Slot>>();
        ArrayList<Slot> slotsCraftingIn = new ArrayList<Slot>();
        ArrayList<Slot> slotsCraftingOut = new ArrayList<Slot>();
        ArrayList<Slot> slotsChest = new ArrayList<Slot>();
        ArrayList<Slot> slotsInventory = new ArrayList<Slot>();
        ArrayList<Slot> slotsInventoryHotbar = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            slotsCraftingIn.add(i, (Slot)this.field_75151_b.get(i));
        }
        slotsCraftingOut.add(0, (Slot)this.field_75151_b.get(9));
        for (i = 0; i < 18; ++i) {
            slotsChest.add(i, (Slot)this.field_75151_b.get(i + 9));
        }
        for (i = 0; i < 27; ++i) {
            slotsInventory.add(0, (Slot)this.field_75151_b.get(i + 27));
        }
        for (i = 0; i < 9; ++i) {
            slotsInventoryHotbar.add(0, (Slot)this.field_75151_b.get(i + 54));
        }
        sections.put(ContainerSection.CRAFTING_IN, slotsCraftingIn);
        sections.put(ContainerSection.CRAFTING_OUT, slotsCraftingOut);
        sections.put(ContainerSection.CHEST, slotsChest);
        sections.put(ContainerSection.INVENTORY, slotsInventory);
        sections.put(ContainerSection.INVENTORY_HOTBAR, slotsInventoryHotbar);
        return sections;
    }
}

