/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.convert;

import com.bluepowermod.convert.IPartConverter;
import com.bluepowermod.convert.part.PartConverterGate;
import com.bluepowermod.convert.part.PartConverterLamp;
import com.bluepowermod.convert.part.PartConverterTube;
import com.bluepowermod.convert.part.PartConverterWire;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.chunk.storage.RegionFile;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.compat.fmp.FMPPart;

public class WorldConverter {
    private static final List<IPartConverter> converters = new ArrayList<IPartConverter>();
    private final File worldFolder;

    public WorldConverter(File worldFolder) {
        this.worldFolder = worldFolder;
    }

    public void convertIfNeeded() {
        if (this.needsConversion()) {
            this.convert();
        }
    }

    public boolean needsConversion() {
        return !new File(this.worldFolder, "bluepower/worldconversion").exists();
    }

    public void convert() {
        File regFolder = new File(this.worldFolder, "region/");
        if (regFolder.exists()) {
            for (File region : this.getRegionFiles(regFolder)) {
                this.convertRegion(region);
            }
        }
        try {
            File f = new File(this.worldFolder, "bluepower/worldconversion");
            f.getParentFile().mkdirs();
            f.createNewFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<File> getRegionFiles(File regionFolder) {
        ArrayList<File> files = new ArrayList<File>();
        for (File f : regionFolder.listFiles()) {
            if (!f.isFile() || !f.getName().toLowerCase().startsWith("r.") || !f.getName().toLowerCase().endsWith(".mca")) continue;
            files.add(f);
        }
        return files;
    }

    private NBTTagCompound getChunk(RegionFile reg, int x, int y) {
        try {
            DataInputStream inputStream = reg.func_76704_a(x & 0x1F, y & 0x1F);
            if (inputStream == null) {
                return null;
            }
            NBTTagCompound tag = CompressedStreamTools.func_74794_a((DataInputStream)inputStream).func_74775_l("Level");
            return tag;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void saveChunk(RegionFile reg, int x, int y, NBTTagCompound chunkData) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Level", (NBTBase)chunkData);
        try {
            DataOutputStream outputStream = reg.func_76710_b(x & 0x1F, y & 0x1F);
            CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)outputStream);
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void convertRegion(File file) {
        RegionFile reg = new RegionFile(file);
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                NBTTagCompound chunk = this.getChunk(reg, x, z);
                if (chunk == null) continue;
                NBTTagList tileEntities = chunk.func_150295_c("TileEntities", (int)new NBTTagCompound().func_74732_a());
                boolean changed = false;
                for (int i = 0; i < tileEntities.func_74745_c(); ++i) {
                    NBTTagCompound te = tileEntities.func_150305_b(i);
                    if (!te.func_74779_i("id").equals("savedMultipart")) continue;
                    changed |= this.convertTile(te);
                }
                if (!changed) continue;
                this.saveChunk(reg, x, z, chunk);
            }
        }
        try {
            reg.func_76708_c();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean convertTile(NBTTagCompound tag) {
        NBTTagList parts = tag.func_150295_c("parts", (int)new NBTTagCompound().func_74732_a());
        int count = parts.func_74745_c();
        FMPPart fmppart = new FMPPart(true);
        for (int i = 0; i < count; ++i) {
            NBTTagCompound part = parts.func_150305_b(i);
            String id = part.func_74779_i("id");
            for (IPartConverter c : converters) {
                IPart p;
                if (!c.matches(id) || (p = c.convert(part)) == null) continue;
                fmppart.addPart(p);
                parts.func_74744_a(i);
                --i;
                break;
            }
            count = parts.func_74745_c();
        }
        if (fmppart.getParts().size() > 0) {
            NBTTagCompound part = new NBTTagCompound();
            fmppart.save(part);
            part.func_74778_a("id", fmppart.getType());
            parts.func_74742_a((NBTBase)part);
            return true;
        }
        return false;
    }

    static {
        converters.add(new PartConverterWire());
        converters.add(new PartConverterLamp());
        converters.add(new PartConverterGate());
        converters.add(new PartConverterTube());
    }
}

